; smbmbr.asm  Small Multi-Boot Master-Boot-Record
; Version 3.0, Dec 17, 1997
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________
;
;  See detailed documenentation in smbmbr.txt
;  See memory layout in smbmbr.lnk
;
;  To build:
;
;  NASM -f obj smbmbr.asm
;  JLOC smbmbr.lnk smbmbr.bin smbmbr.map
;
;  (I used NASM version 0.97 and JLOC version 0.3 in testing)
;_____________________________________________________________________________


	struc	PT_ENT		;Partition table entry
BootFlag	resb	1
BeginHead       resb	1
BeginSector     resb	1
BeginCyl        resb	1
SystemID        resb	1
EndHead         resb	1
EndSector       resb	1
EndCyl          resb	1
RelSectorLow    resw	1
RelSectorHigh   resw	1
NumSectorsLow   resw	1
NumSectorsHigh  resw	1
	endstruc

	struc	CHOICE		;Choice table entry
drive		resb	1
letter		resb	1
	endstruc

	extern	reloc_start	;.LNK file defines relocation address (0:7A00)

tick	equ	0x46C		;Location where the BIOS keeps the tick count

SEGMENT START USE16			;At 0:7C00

start:
	xor	cx, cx			;Set segment registers to zero
	mov	es, cx
	mov	ds, cx
	mov	ss, cx
	mov	sp, reloc_start		;Top of stack
	mov	di, sp			;  is bottom of relocation point
	mov	si, start
	cld
	mov	ch, 1			;cx = 256
	rep movsw			;Copy self to 0:7A00
	jmp	continue		;near JMP to copy of self

SEGMENT MAIN USE16			;At 0:7A00 + START.length
continue:
	sti
	mov	si, message		;Main message
again:
	mov	ax, 0x0E0D		;Start with CR
	mov	bx, 7			;Normal display attribute
disp:	int	10h			;Display one character
	lodsb				;Get next char of message
	test	al, al			;Null terminated
	jnz	disp

	mov	bx, 182*5/10		;Allow up to five seconds
	add	bx, [tick]		; beyond current tick count

keywait:
	mov	ah, 1			;Test for keystroke
	int	16h
	jnz	getkey			;Got one
	cmp	bx, [tick]		;Check current tick count
	jns	keywait			;Keep waiting

	mov	al, [last_boot]		;Timeout:  Get default
	jmp short gotkey

getkey:	mov	ah, 0			;Read the key
	int	16h
gotkey:
	cmp	al, 'a'			;Convert to upper case
	jb	.10
	sub	al, 'a'-'A'
.10:	push	ax			;Save
	mov	ah, 0xE			;Echo choice
	mov	bx, 0x15		;  bold attribute
	int	10h
	mov	al, 13			;Newline
	int	10h
	mov	al, 10
	int	10h
	pop	ax			;Restore

	mov	di, PartitionTable	;Start of partition table
	mov	si, di			; is also end of choice table

.20:	sub	si, byte CHOICE_size	;Loop through choice table
	cmp	[si+letter], al		;Found it?
	je	found			;Yes
	cmp byte [si+letter], 0		;Done whole table?
	jne	.20			;No

	mov	si, wrong		;Error message
again2:	jmp short again			;Try again

found:	mov	dl, [si+drive]		;Get drive or partition Number
	mov	cx, 1			;Sector 1 / Cylinder 0
	mov	dh, 0			;Head 0
	cmp	dl, 0xFC		;Is it a partition code?
	jb	go			;No: it is a drive number
	mov	[last_boot], al		;Save choice as new default
	mov	ax, PT_ENT_size		;Compute location of partition entry
	mul	dx
	add	ax, PartitionTable - (0xFC * PT_ENT_size)
	mov	[di], ch		;Mark all four partitions nonactive
	mov	[di+PT_ENT_size], ch
	mov	[di+2*PT_ENT_size], ch
	mov	[di+3*PT_ENT_size], ch
	xchg	ax, di			;DI = selected entry
	mov	dx, 0x80		;hard-drive-0 / head 0
	mov	[di], dl		;Mark it active

	mov	bx, reloc_start		;0:7A00
	mov	cx, 1			;Sector 1 / Cylinder 0
	mov	ax, 0x301		;Command to write one sector
	int	13h			;Rewrite boot block
	jc	fail			;Failed

	mov	cx, [di+BeginSector]	;Sector / Cylinder
	mov	dx, [di+BootFlag]	;Drive / Head
go:	mov	si, 3			;Three tries
try:	mov	bx, start		;Read it into 0:7C00
	mov	ax, 0x201		;Command to read one sector
	int	13h
	jnc	ok			;Success
	dec	si			;retry count
	jnz	try
fail:	mov	si, failed		;Error message
	jmp short again2		;Try again

ok:	jmp	start			;Start partition boot block

last_boot	db	'1'		;Default for next boot

failed		db	10,'Disk error',13
wrong		db	10,'Try again: ',0

;message is the instructions the user sees, telling him which keys mean
;what.  After you edit the choice table (see below), edit the message to
;correspond.  It is just a message, so the program won't care if it doesn't
;correspond with the choice table.  In this example, the choice table has
;choices 3 and 4 which aren't in the message
;_____________________________________________________________________________

message		db	10,'Press A to boot the A floppy',13
		db	10,'Press 1 to boot Windows 95',13
		db	10,'Press 2 to boot DOS / Windows 3.11',13
		db	10,'Selection: ',0

SEGMENT FINAL USE16			;.LNK file aligns this to end of sector

;Choice table is accessed backwards from the start of the partition table
;You should edit the choice table to represent the choices that make
;sense on your system.  The first byte of each choice represents the
;action:
;           0  ->  A:
;           1  ->  B:
;        0x81  ->  Hard drive 1
; 0xFC - 0xFF  ->  First through fourth entry in partition table.
;
;Note that fdisk generally doesn't number partitions according to their
;position in the partition table, so you need to find out some other
;way.
;
;The second byte in each choice entry is the key used to select it.
;_____________________________________________________________________________

	db	0			;Flag (backwards) end of table
	db	0,    'A'
	db	0xFC, '1'
	db	0xFD, '2'
	db	0xFE, '3'
	db	0xFF, '4'

PartitionTable  resb 4*PT_ENT_size
	dw	0AA55h
