#include <string.h> /* memset() */
/* FILE, SEEK_..., fopen(), fseek(), ftell(), fread(), fclose(), printf() */
#include <stdio.h>
#include <bios.h> /* biosdisk() */

#define	BUF_SIZE	512
/*****************************************************************************
*****************************************************************************/
int main(int arg_c, char *arg_v[])
{
	unsigned char buf[BUF_SIZE], tries;
/*	char *outfile_name = "A:\\LOADER.BIN"; */
	FILE *infile;/*, *outfile;*/
	long len;
	int err;

/* usage */
	if(arg_c < 2)
	{
		printf("Writes first 512 bytes of file to floppy boot "
			"sector\n");
/*			"sector,\nthen writes the rest to file %s\n",
			outfile_name); */
		return 1;
	}
/* open input file */
	infile = fopen(arg_v[1], "rb");
	if(infile == NULL)
	{
		printf("Can't open input file '%s'\n", arg_v[1]);
		return 1;
	}
/* get length */
	fseek(infile, 0, SEEK_END);
	len = ftell(infile);
	fseek(infile, 0, SEEK_SET);
/* check length */
	if(len < BUF_SIZE)
	{
		printf("Warning: short file. Boot sector will be padded "
			"with zeroes\n");
/*			"with zeroes and file %s won't be written\n",
			outfile_name); */
	}
/* read bootsector */
	memset(buf, 0, sizeof(buf));
	fread(buf, 1, BUF_SIZE, infile);
/* write it */
	for(tries = 3; tries != 0; tries--)
	{
		err = biosdisk(/* _DISK_WRITE */3, /* drive */0, /* head */0,
			/* track */0, /* sector */1, /* nsects */1, buf);
		if(err == 0x11)
			err = 0;
		if(err == 0)
			break;
		(void)biosdisk(/* _DISK_RESET */0, /* drive */0,
			0, 0, 1, 1, buf);
	}
	if(err != 0)
	{
		printf("Error 0x%X writing boot sector\n", err);
		return 1;
	}
/* open output file
	if(len > BUF_SIZE)
	{
		outfile = fopen(outfile_name, "wb");
		if(outfile == NULL)
		{
			printf("Can't open output file '%s'\n", outfile_name);
			return 1;
		}
		do
		{
			err = fread(buf, 1, BUF_SIZE, infile);
			if(err >= 0)
				fwrite(buf, 1, err, outfile);
		} while(err > 0);
		fclose(outfile);
		if(err < 0)
		{
			printf("Error writing file '%s'\n", outfile_name);
			return 1;
		}
	}*/
	return 0;
}
