/*----------------------------------------------------------------------------
VIDEO.C

EXPORTS:
void clear_screen(void);
void putch(unsigned c);
----------------------------------------------------------------------------*/
#include <string.h> /* memsetw() */
#include <stdint.h> /* uint16_t */
#include <x86.h> /* outportb() */

static uint16_t *g_fb_adr = (uint16_t *)0xB8000;
static unsigned g_vc_width = 80, g_vc_height = 25;
static unsigned g_csr_x, g_csr_y, g_crtc_io_adr = 0x3D4;
/*****************************************************************************
*****************************************************************************/
static void move_csr(void)
{
	unsigned i;

	i = g_csr_y * g_vc_width + g_csr_x;
	outportb(g_crtc_io_adr + 0, 14);
	outportb(g_crtc_io_adr + 1, i >> 8);
	outportb(g_crtc_io_adr + 0, 15);
	outportb(g_crtc_io_adr + 1, i);
}
/*****************************************************************************
this does not move the hardware cursor
*****************************************************************************/
void clear_screen(void)
{
/* 0x720 is white-on-black (attribute 0x07) ASCII space (character 0x20) */
	memsetw(g_fb_adr, 0x720, g_vc_height * g_vc_width);
}
/*****************************************************************************
*****************************************************************************/
void putch(unsigned c)
{
/* backspace */
	if(c == 0x08)
	{
		if(g_csr_x != 0)
			g_csr_x--;
	}
/* tab */
	else if(c == 0x09)
		g_csr_x = (g_csr_x + 8) & ~(8 - 1);
/* carriage return */
	else if(c == '\r')	/* 0x0D */
		g_csr_x = 0;
/* line feed */
//	else if(c == '\n')	/* 0x0A */
//		g_csr_y++;
/* CR/LF */
	else if(c == '\n')	/* ### - 0x0A again */
	{
		g_csr_x = 0;
		g_csr_y++;
	}
/* printable ASCII */
	else if(c >= ' ')
	{
		uint16_t *where;

		where = g_fb_adr + (g_csr_y * g_vc_width + g_csr_x);
		*where = (c | 0x700);
		g_csr_x++;
	}
	if(g_csr_x >= g_vc_width)
	{
		g_csr_x = 0;
		g_csr_y++;
	}
/* instead of scrolling, wrap the cursor to upper left corner */
	if(g_csr_y >= g_vc_height)
		g_csr_y = 0;
	move_csr();
}
