#ifndef __TL_STDINT_H
#define	__TL_STDINT_H

#ifdef __cplusplus
extern "C"
{
#endif

/* this file seems like a good place for this: */
#if defined(__GNUC__)
#define	__PACKED__	__attribute__((packed))
#else
#define	__PACKED__	/* nothing */
#endif

/* C99 7.18.1.1 - Exact-width integer types */
typedef signed char		int8_t;
typedef short			int16_t;
typedef long			int32_t;
#if defined(__GNUC__)
typedef long long		int64_t;
#endif

typedef unsigned char		uint8_t;
typedef unsigned short		uint16_t;
typedef unsigned long		uint32_t;
#if defined(__GNUC__)
typedef unsigned long long	unt64_t;
#endif

/* C99 7.18.1.4 - Integer types capable of holding object pointers */
typedef int			intptr_t;
typedef unsigned		uintptr_t;

/* C99 7.18.2.1 - Limits of exact-width integer types */
#define INT8_MIN	-128
#define INT8_MAX	127
#define UINT8_MAX	255
#define INT16_MIN	-32768
#define INT16_MAX	32767
#define UINT16_MAX	65535u
#define INT32_MIN	(-2147483647L-1)
#define INT32_MAX	2147483647L
#define UINT32_MAX	4294967295uL

/* C99 7.18.2.4 - Limits of integer types capable of holding object pointers */
#define INTPTR_MIN	(-2147483647L-1)
#define INTPTR_MAX	2147483647L
#define UINTPTR_MAX	4294967295uL

/* C99 7.18.2.5 - Limits of greatest-width integer types */
#define INTMAX_MIN	(-2147483647L-1)
#define INTMAX_MAX	2147483647L
#define UINTMAX_MAX	4294967295uL

#ifdef __cplusplus
}
#endif

#endif
