; testload.asm  test code for boot12 and boot16
; Version 1.0, Jul 5, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________
;
;  To compile, use NASM
;
;  nasm testload.asm -o testload.bin
;
;  To install, copy to the root of the desired volume renamed as LOADER.BIN
;
;  copy testload.bin a:\loader.bin
;_____________________________________________________________________________
;
;  This code just displays the message "LOADER.BIN is running" and then hangs.
;
;  I put a long run of zeroes in the middle of the file so that I could make
;  it longer than 64Kb so that it would be a more complete test of the boot
;  code.
;
;  This kludgy way of supporting multiple segments is OK for something as
;  simple as this test, and has the advantage of not binding the load address
;  until run time.  For a more complicated image that needs to be over 64Kb,
;  I strongly recommend that you select a specific load address and use my
;  linker JLOC to avoid these run-time kludges.

begin:	mov	ax, cs		;Get the current segment
	mov	ds, ax		;The data is in this segment
	add	ax, 0x1000	;Compute next segment
	push	ax		;Build return address
	xor	ax, ax
	push	ax
	retf			;Go to the code in the next segment

msg1	db	13,10,'LOADER.BIN is running',0

	times (0x10000 - $ + begin) db 0

;  This is address zero of the segment 0x1000 paragraphs beyond our
;  Initial segment
;
	mov	si, msg1	;Address of message
	call	display		;Display it
	jmp $			;Hang

disp0:				;Continue point for display
	mov	ah, 0xE
	mov	bx, 7
	int	10h
display:			;Routine to display a message
	lodsb			;Get next byte
	test	al, al		;End of message
	jnz	disp0		;No: continue displaying
	ret			;Yes: return
