; v86.asm  Support routines for V86 mode
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

	GLOBAL	_call_BIOS
	GLOBAL	_call_V86
	GLOBAL	service_hw
	GLOBAL	v86_revector
	GLOBAL	tss
	GLOBAL	tss_size
	GLOBAL	esp0
	GLOBAL	v86k_esp

	%include "intframe.inc"
	%include "gdt.inc"
	%include "idt.inc"
	%include "8259.inc"

	SEGMENT	CODE   USE32
	SEGMENT V86    USE16
	SEGMENT DATA   USE32 align=4

	extern	idt		;The IDT itself
	extern  FLAT_DATA
	extern  FLAT_CODE
	extern	stack0top

	SEGMENT	CODE

; void call_BIOS(INTFRAME *before, INTFRAME *after, int number, char ah);
;
;  Copies AH plus the EIP and CS from the specified interrupt vector, and
;  the flag value 0x23002 into the before frame and then does call_V86()
;
_call_BIOS:
	push	ebx
	push	esi
	push	edi
	push	ebp
%assign args 20
	mov	ebp, esp
	mov	ebx, [ebp+args]		;Before frame
	mov	cl, [ebp+args+12]	;AH value
	mov	[fr.ah+ebx], cl		;Put it into before frame
	mov	eax, [ebp+args+8]	;Interrupt number
	mov	eax, [ZERO+eax*4]	;Get the vector
	movzx	edx, ax			;Extend IP part to EIP
	shr	eax, 16			;Get CS part
	mov	[fr.eip+ebx], edx	;Put EIP in before frame
	mov	[fr.cs+ebx], eax	;Put CS in before frame
	mov	dword [fr.eflags+ebx], 0x23002
	jmp short _call_V86.1		;Merge with main entry point

; void call_V86(INTFRAME *before, INTFRAME *after);
;
;  Pushes three words (for iret or far ret) on the current v86 mode
;  stack.
;
;  Changes the p_ds, p_es, esp and ss fields in the before frame to
;  allow that frame to be used to transfer control to V86 mode.
;
;  When that v86 mode code exits with iret or far ret, the registers
;  are put in the after frame, and the caller of call_V86 is resumed.
;
_call_V86:
	push	ebx
	push	esi
	push	edi
	push	ebp
	mov	ebx, [esp+args]		;Before frame
.1:	xor	eax, eax		;Need NULL p_ds and p_es for
	mov	[fr.p_ds+ebx], eax	; standard INT_EXIT macro for V86
	mov	[fr.p_es+ebx], eax

	pushf					;Save interrupt enable bit
	mov	esi, [v86k_esp]			;Get existing V86 frame limit
	push	dword [esp0]			;Save esp0
	push	esi				;Save V86 frame limit
%assign args args+12				;Count 3 more dwords on stack
	cli					;Can't allow interrupts between
						;changing esp0 and IRETing
	mov	[esp0], esp			;Set new V86 frame limit
	mov	[v86k_esp], esp
	movzx	eax, word [fr.sp+esi-fr_size]	;Get V86 sp
	movzx	ecx, word [fr.ss+esi-fr_size]	;Get V86 ss
	sub	eax, byte 6			;Make room on V86 stack
	mov	[fr.esp+ebx], eax		;Store in before frame
	mov	[fr.ss+ebx], ecx
	shl	ecx, 4				;V86 stack segment base

	mov dword [ZERO+eax+ecx+2], 0x3002FFFF	;Create a return point for the
	mov word [ZERO+eax+ecx], unwind_sw	;V86 routine at FFFF:unwind_sw
	mov	esp, ebx			;Use before frame as a stack
	INT_EXIT
SEGMENT V86

; There is no way to "return" from V86 mode to pmode.  When the kernel
; inverts a call to V86 mode (into an iret) it must give the V86 routine
; somewhere to return.  That return must still be in V86 mode.  That return
; must then interrupt into pmode to cause the real return.
;
; All that explanation for one little instruction . . .
;_____________________________________________________________________________
unwind_sw: int	46h				;Get out of V86 mode
SEGMENT CODE

; The above instruction will bring us in here to clean up the stack and
; really return.
;_____________________________________________________________________________
service_46:
patch_vec 0x46, service_46, D_INT+D_DPL3	;Patch vector to point here
	INT_ENTRY	eax			;Build standard stack frame
	mov	esi, esp			;Address of stack frame
	mov	edi, [esp+fr_size+args+4]	;Address of the after structure
	mov	ecx, fr_size/4
	rep movsd				;Copy it.
	mov	esp, esi			;Remove from stack
	pop	dword [v86k_esp]		;Restore old V86 frame
	pop	dword [esp0]
	popf					;Restore interrupt enable
	pull	ebx,esi,edi,ebp			;Restore registers
	ret

; Revector each of the 15 IRQ's into V86 mode.
;
; After pmode service code is written for some hardware interrupts, those
; should be removed from this list.

	hw_revector	M_VEC+0,	8
	hw_revector	M_VEC+1,	9
	hw_revector	M_VEC+3,	11
	hw_revector	M_VEC+4,	12
	hw_revector	M_VEC+5,	13
	hw_revector	M_VEC+6,	14
	hw_revector	M_VEC+7,	15
	hw_revector	S_VEC+0,	0x70
	hw_revector	S_VEC+1,	0x71
	hw_revector	S_VEC+2,	0x72
	hw_revector	S_VEC+3,	0x73
	hw_revector	S_VEC+4,	0x74
	hw_revector	S_VEC+5,	0x75
	hw_revector	S_VEC+6,	0x76
	hw_revector	S_VEC+7,	0x77

; The hw_revector macro pushes the contents of the desired vector (in the
; place where a fault would push an error code) then JMPs here to do the
; real work of revectoring.
;
; If the interrupt occurred while the CPU was in V86 mode, we can redispatch.
;
; If the interrupt occurred while the CPU was in pmode, it is a slightly
; stickier problem.
;
; The whole hardware revectoring process occurs with interrupts off, so we
; won't tangle the stacks if another interrupt occurs.
;_____________________________________________________________________________
service_hw:
	INT_ENTRY
	mov	ebp, esp

	test	byte [fr.flags+2+ebp], 2	;Interrupted V86?
	jz	prot_revector			;No interrupted pmode
	mov	eax, [fr.error_code+ebp]	;Vector contents

v86_revector:

; v86_revector is used for both hardware and software interrupts.  It can only
; be used if the interrupt occurred from V86 mode.  To use it, jmp here with
; both esp and ebp pointing to the frame, and with eax containing the CONTENTS
; of the vector.

	movzx	ebx, word [fr.ss+ebp]		;ss
	shl	ebx, 4
	sub	word [fr.sp+ebp], byte 6	;Make room on v86 stack
	add	ebx, [fr.esp+ebp]		;Linear address
	xchg	ax, [fr.ip+ebp]			;ip
	rol	eax, 16				;Swap halves of eax
	xchg	ax, [fr.cs+ebp]			;cs
	rol	eax, 16
	mov	[ZERO+ebx], eax
	mov	eax, [fr.eflags+ebp]		;Flags
	mov	[ZERO+ebx+4], ax		;Saved flags
	and	byte [fr.flags+1+ebp], 0xFD	;CLI
	INT_EXIT

prot_revector:
	mov	ebx, [v86k_esp]			;Get existing V86 frame limit
	push	dword [esp0]
	push	ebx				;Save V86 frame limit
	mov	[esp0], esp			;Set new V86 frame limit
	mov	[v86k_esp], esp
	sub	esp, byte 16			;Random ds, es, fs and gs
	movzx	eax, word [fr.sp+ebx-fr_size]	;Get V86 sp
	movzx	ebx, word [fr.ss+ebx-fr_size]	;Get V86 ss
	sub	eax, byte 6			;Make room on V86 stack
	push	ebx				;New V86 frame: ss
	push	eax				;New V86 frame: sp
	shl	ebx, 4				;V86 stack segment base

	mov dword [ZERO+eax+ebx+2], 0x3002FFFF	;Create a return point for the
	mov word [ZERO+eax+ebx], unwind		;V86 routine at FFFF:unwind

	push	dword 0x23002			;New V86 frame: flags
	movzx	eax, word [fr.error_code+2+ebp]	;High half of vector
	push	eax				;New V86 frame: cs
	movzx	eax, word [fr.error_code+ebp]	;Low half of vector
	push	eax				;New V86 frame: ip
	iretd					; "CALL" V86 interrupt routine

; The V86 segment is code that must execute in V86 mode.  JLOC adjusts things
; so that the V86 code has a base of FFFF:0.
;_____________________________________________________________________________
SEGMENT V86

; There is no way to "return" from V86 mode to pmode.  When the kernel
; inverts a call to V86 mode (into an iret) it must give the V86 routine
; somewhere to return.  That return must still be in V86 mode.  That return
; must then interrupt into pmode to cause the real return.
;
; All that explanation for one little instruction . . .
;_____________________________________________________________________________
unwind:	int	41h				;Get out of V86 mode
SEGMENT CODE

; The above instruction will bring us in here to clean up the stack and
; really return.
;_____________________________________________________________________________
service_41:
patch_vec 0x41, service_41, D_INT+D_DPL3	;Patch vector to point here
	add	esp, 9*4			;Discard current V86 frame
	pop	dword [ss:v86k_esp]		;Restore old V86 frame limit
	pop	dword [ss:esp0]
	INT_EXIT

SEGMENT DATA
tss:    dd      0
esp0:   dd      stack0top
ss0:    dd      FLAT_DATA
	resb	0x66 - 0xC
	dw	0x68
; I/O restrictions
	resb	8192			;0 - FFFF unrestricted
tss_size equ $-tss

v86k_esp dd	stack0top

