// test.c  Kludge test code for various kernel services
// Version 2.0, Sep 12, 1999
// Sample code
// by John S. Fine  johnfine@erols.com
// I do not place any restrictions on your use of this source code
// I do not provide any warranty of the correctness of this source code
//_____________________________________________________________________________

#include "intframe.h"

extern BYTE B8000[];

// I don't know how to extern a literal in C so I will use a kludge
extern BYTE RING3_CODE[];
extern BYTE RING3_DATA[];

int get_key(void);
int read_sectors(int drive_num, long sector, long sector_count, void *buffer);
void call_RING3(INTFRAME *before, INTFRAME *after);

void test_r3(void);

void test(void) {
   INTFRAME fr;
   char buf[512];
   int tmp;

   for (;;) {

      tmp = get_key();
      switch ( (char) tmp | 0x20 ) {

         case 'f':  // read from A: sector 19 (root dir, if standard 1.44Mb)
            read_sectors(0, 19, 1, buf);
            for (tmp=512; --tmp >=0;)
               B8000[tmp*2] = buf[tmp];
            break;

         case '3':  // call ring 3 code
            fr.d.p_ds = fr.d.p_es = (int)RING3_DATA+3;
            fr.d.cs   = (int)RING3_CODE+3;
            fr.d.eip  = (int)test_r3;
            fr.d.eflags = 0x3002;
            call_RING3(&fr, &fr);
            break;

// A bunch of options for testing paths into the stack dump code

         case '0':  // pmode divide by zero
            tmp /= ((char *)&tmp)[3];
            break;

         case 'v':  // V86 mode GPF
            call_BIOS(&fr,&fr,0x15,0x87);
            break;

         case 'n':  // Not present
            asm("mov $32,%ax\n mov %ax,%gs");
            break;

         case 'p':  // Page fault
            *((char *)(0xAA000000)) = 0;
            break;
         }
      }
}

void test_r3(void) {
   char *from = "  Now executing in ring 3  ";
   BYTE *to = B8000;

   do {
      *to++ = *from++;
      *to++ = 15;
      } while (*from);

   to[0] = get_key();
   to[2] = ' ';
}

