; start.asm  Skeleton startup module for a pmode kernel
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

	GLOBAL FLAT_CODE
	GLOBAL FLAT_DATA
	GLOBAL _RING3_CODE
	GLOBAL _RING3_DATA
	GLOBAL stack0top
	GLOBAL _gdt

	%include "intframe.inc"
	%include "gdt.inc"
	%include "idt.inc"
	%include "8259.inc"

	SEGMENT	START  USE32
	SEGMENT	CODE   USE32
	SEGMENT CONST  USE32 align=4
	SEGMENT DATA   USE32 align=4
	SEGMENT BSS    USE32 align=4
	SEGMENT PAGE   USE32 align=4096
	SEGMENT V86    USE16
	SEGMENT STACK  USE32 align=16

	extern	init_8259	;Initialize the interrupt controller
	extern	init_idt	;Initialize the IDT
	extern	idt		;The IDT itself
	extern	tss
	extern	tss_size
	extern	esp0
	extern	_test
	extern	stack3top

; We get here straight from bootf.  We have a temporary GDT from bootf and
; temporary page tables and a temporary stack and no TSS and no IDT.
; For now, the temporary page tables are good enough, but rest must be fixed.
;_____________________________________________________________________________
SEGMENT	START
	lgdt	[_gdt]				;Load GDT
	lss	esp, [esp0]			;Initialize stack
	sub	esp, byte fr_size		;Initial V86 frame
	mov	word [esp+fr.ss], 0x6C00	;Initialize V86 stack
	mov	dword [esp+fr.esp], 0xFFFE

	sub	esp, byte fr_size		;Initial r3 frame
	mov	word [esp+fr.ss], _RING3_DATA+3
	mov	dword [esp+fr.esp], stack3top

	push	dword 0x3002			;Initial flags value
	popf					;Fix nested task glitch
	mov	ax, TSS				;Load TSS selector
	ltr	ax
	call	init_idt			;Load IDTR
	in	al, M_IMR			;Save interrupt mask registers
	push	eax
	in	al, S_IMR
	push	eax
	call	init_8259			;Init interrupt controller
	pop	eax				;Restore interrupt mask regs
	out	S_IMR, al
	pop	eax
	out	M_IMR, al
	sti
	jmp	_test

SEGMENT CONST
_gdt		start_gdt
FLAT_CODE	desc	0,   0xFFBFF,    D_CODE+D_READ+D_BIG+D_BIG_LIM
FLAT_DATA	desc	0,   0xFFFFF,    D_DATA+D_WRITE+D_BIG+D_BIG_LIM
TSS		desc	tss, tss_size-1, D_TSS
EXTRA_DESC	desc	0,	   0,	 D_DATA+D_NOT_PRESENT
_RING3_CODE	desc	0,   0xFFBFF,    D_CODE+D_READ+D_BIG+D_BIG_LIM+D_DPL3
_RING3_DATA	desc	0,   0xFFBFF,    D_DATA+D_WRITE+D_BIG+D_BIG_LIM+D_DPL3
		end_gdt


SEGMENT STACK
	resd	4096
stack0top:
