; ring3.asm is a kludge I wrote to call ring3 code from
; the kernel.  I just wrote it to be able to test that the stack
; manipulations work correctly when calling V86 mode from ring 3.

	GLOBAL _call_RING3
	GLOBAL r3k_esp
	GLOBAL stack3top

	%include "intframe.inc"
	%include "gdt.inc"
	%include "idt.inc"

	SEGMENT	CODE   USE32
	SEGMENT DATA   USE32 align=4

	extern	esp0
	extern	idt
	extern  FLAT_CODE
	extern  _RING3_CODE
	extern  _RING3_DATA
	extern	stack0top

	SEGMENT	CODE
	
; void call_RING3(INTFRAME *before, INTFRAME *after);

_call_RING3:
	push	ebx
	push	esi
	push	edi
	push	ebp
%assign args 20
	mov	ebx, [esp+args]		;Before frame

	pushf					;Save interrupt enable bit
	mov	esi, [r3k_esp]			;Get existing r3 frame limit
	push	dword [esp0]			;Save esp0
	push	esi				;Save r3 frame limit
%assign args args+12				;Count 3 more dwords on stack
	cli					;Can't allow interrupts between
						;changing esp0 and IRETing
	mov	[esp0], esp			;Set new r3 frame limit
	mov	[r3k_esp], esp
	mov	eax, [fr.esp+esi-fr_size]	;Get r3 esp
	mov	ecx, [fr.ss+esi-fr_size]	;Get r3 ss
;;;
;;;  If the ring3 address space were not the same as the kernel address
;;;  space, some extra work would be required here.
;;;
	sub	eax, byte 12			;Make room on r3 stack
	mov	[fr.esp+ebx], eax		;Store in before frame
	mov	[fr.ss+ebx], ecx

	mov	dword [eax], unwind		;Create a return point for the
	mov	word [eax+4], _RING3_CODE+3	;r3 routine at unwind
	mov	dword [eax+8], 0x3002
	mov	esp, ebx			;Use before frame as a stack
	INT_EXIT

unwind: int 42h
service_42:
patch_vec 0x42, service_42, D_INT+D_DPL3	;Patch vector to point here
	INT_ENTRY	eax			;Build standard stack frame
	mov	esi, esp			;Address of stack frame
	mov	edi, [esp+fr.r3size+args+4]	;Address of the after structure
	mov	ecx, fr.r3size/4
	rep movsd				;Copy it.
	mov	esp, esi			;Remove from stack
	pop	dword [r3k_esp]			;Restore old V86 frame
	pop	dword [esp0]
	popf					;Restore interrupt enable
	pull	ebx,esi,edi,ebp			;Restore registers
	ret

	SEGMENT DATA
r3k_esp	dd	stack0top-fr_size

SEGMENT STACK
	resd	4096
stack3top:

