// readsect.c
// Version 2.0, Sep 12, 1999
// Sample code
// by John S. Fine  johnfine@erols.com
// I do not place any restrictions on your use of this source code
// I do not provide any warranty of the correctness of this source code
//_____________________________________________________________________________
// temporary version of read_sectors
// most of this code should be moved to int25 or int13 and read_sectors should
// be an ASM wrapper for int25
//
// Uses a buffer at physical address 0x600 for up to a track of data from
// the disk.  In a real OS we would have memory management and the buffer
// would be allocated rather than just used.

int sectors_per_track = 18;    // Need to invent a better way to manage this
int tracks_per_cylinder = 2;   // information.

#include "intframe.h"

int read_sectors(int drive_num, long sector, long sector_count, void *buffer) {
   int track;
   int cyln;
   int head;
   int sect;
   int first_part;
   INTFRAME fr;

   do {
      track = sector / sectors_per_track;
      sect  = sector % sectors_per_track;
      cyln  = track / tracks_per_cylinder;
      head  = track % tracks_per_cylinder;

      first_part = sectors_per_track - sect;
      if (first_part > sector_count)
         first_part = sector_count;

      fr.b.al = first_part;
      fr.b.cl = sect+1 + ((cyln>>2)&0xC0);
      fr.b.ch = cyln;
      fr.b.dl = drive_num;
      fr.b.dh = head;
      fr.w.bx = 0;
      fr.w.v_es = 0x60;

      call_BIOS(&fr, &fr, 0x13, 2);

      memcpy(buffer, (void *)0x600, first_part<<9);

      }  while (sector_count -= first_part);

   return (0);  // Optimist
}


