; intframe.inc  Interrupt frame structure
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

; The symbol ZERO is used to mark places where my code assumes that offset zero
; is equal to linear zero.  These places must be fixed if this code is used in
; a kernel in which that is not true.  Depending on your design, the fix may be
; as easy as changing the value of ZERO defined here.
;
%define ZERO 0

; The structure fr is the stack frame used for almost all interrupt entries.
; The beginning of the structure is always the same, but the end might not be
; present depending on the interrupted mode.  If ring 0 was interrupted,
; nothing after .flags is present.  If pmode was interrupted, nothing after
; .ss is present.
;
	struc	fr
.p_ds		resd	1
.p_es		resd	1
.edi:
.di		resw	2
.esi:
.si		resw	2
.ebp:
.bp		resw	2
.extra		resd	1
.ebx:
.bx:
.bl		resb	1
.bh		resb	3
.edx:
.dx:
.dl		resb	1
.dh		resb	3
.ecx:
.cx:
.cl		resb	1
.ch		resb	3
.eax:
.ax:
.al		resb	1
.ah		resb	3
.error_code	resd	1
.eip:
.ip:		resw	2
.cs		resd	1
.eflags:
.flags:		resw	2
.r0size:
.esp:
.sp		resw	2
.ss		resd	1
.r3size:
.v_es		resd	1
.v_ds		resd	1
.v_fs		resd	1
.v_gs		resd	1
	endstruc

%macro	pmov	2
	push	%2
	pop	%1
%endmacro

; INT_ENTRY is used to create the part of the stack frame that was not created
; by the interrupt itself.  Use INT_ENTRY with no parameters if the interrupt
; had an error code.  Otherwise, use one parameter (usually a register) just to
; take up space.
;
; INT_ENTRY also copies ss to ds and es, so the kernel data segment can be
; used.  INT_ENTRY does not copy esp to ebp.  That is often the first
; instruction after INT_ENTRY.
;
%macro	INT_ENTRY 0-1+
%if %0
	push	%1
%endif
	pusha
	push	es
	push	ds
	pmov	ds, ss
	pmov	es, ss
%endmacro

; INT_EXIT returns using a standard stack frame
;
%macro	INT_EXIT 0
	pop	ds
	pop	es
	popa
	add	esp, byte 4
	iret
%endmacro

; "hw_revector"  sets up the stub and the patch to revector a hardware
; interrupt to V86 mode.
;
; hw_revector  pp  vv
;
;  will redirect protected mode interrupt number pp to V86 mode interrupt
;  number vv.
;_____________________________________________________________________________
	%macro hw_revector 2
%%service:
patch_vec %1, %%service, D_INT
	push	dword [ss:ZERO+%2*4]
	jmp	service_hw
	%endmacro

;   "pull"  pops a bunch of things in reverse order.  For example,
;
;        pull  eax, ebx, ebp
;   generates
;        pop   ebp
;        pop   ebx
;        pop   eax
;_____________________________________________________________________________
       %macro pull 1-*
       %rep %0 
       %rotate -1 
		pop %1
       %endrep 
       %endmacro

