// intframe.h  Structure for interrupt stack frame
// Version 2.0, Sep 12, 1999
// Sample code
// by John S. Fine  johnfine@erols.com
// I do not place any restrictions on your use of this source code
// I do not provide any warranty of the correctness of this source code
//_____________________________________________________________________________

// A few important definitions that probably go in some other .h file once
// this is better organized.

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;
#define elementsof(x) (sizeof(x)/sizeof(*(x)))

// To simplify OS coding, we will have all software interrupts and all faults
// set up the same stack frame.

// Some faults have error codes.  To keep a single version of stack frame
// the ones that don't have an error code push an extra copy of eax.

// Many elements can be viewed three different ways, so the whole frame is
// expressed as a union.

// I changed the word "caller" to "client" in here, so that when we talk about
// interrupt service helper routines, we don't get confused.  "caller" is the
// caller of the current routine.  "client" is the caller of the main service.

// The location of ds and es in the stack frame depends on the type of
// client.
// If the client is in V86 mode then ds and es will be in .v_ds and .v_es.
// (.p_ds and .p_es will be zero and must remain zero for the return to
// work correctly.
// If the client is in pmode then the v_ elements won't be present at all
// and the client's ds, es will be in .p_ds and .p_es.
// (If the client is in pmode ring zero, then .esp and .ss won't be present)

// When a C routine is the primary service routine for an interrupt.  Its
// parameter will be the actual INTFRAME structure (not a pointer).  When a C
// routine is a subfunction or helper routine for an interrupt, one of its
// parameters will be a pointer to the INTFRAME

// The high half of each saved sreg is filled with trash by the CPU.  When
// reading an sreg you must either use the word form or mask the dword form
// (.w.ds or .d.ds & 0xFFFF).  When writing an sreg you can write either the
// word or the dword and not worry about what happens to the trash half).

typedef union {

   struct {
      DWORD   p_ds;
      DWORD   p_es;
      DWORD   edi;
      DWORD   esi;
      DWORD   ebp;
      DWORD   extra;
      DWORD   ebx;
      DWORD   edx;
      DWORD   ecx;
      DWORD   eax;
      DWORD   error_code;
      DWORD   eip;
      DWORD   cs;
      DWORD   eflags;
      DWORD   esp;
      DWORD   ss;
      DWORD   v_es;
      DWORD   v_ds;
      DWORD   v_fs;
      DWORD   v_gs;
      } d;

   struct {
      WORD    p_ds,       d_ds_trash;
      WORD    p_es,       p_es_trash;
      WORD    di,         edi_h;
      WORD    si,         esi_h;
      WORD    bp,         ebp_h;
      WORD    extra,      extra_h;
      WORD    bx,         ebx_h;
      WORD    dx,         edx_h;
      WORD    cx,         ecx_h;
      WORD    ax,         eax_h;
      WORD    error_code, error_code_h;
      WORD    ip,         eip_h;
      WORD    cs,         cs_trash;
      WORD    flags,      eflags_h;
      WORD    sp,         esp_h;
      WORD    ss,         ss_trash;
      WORD    v_es,       v_es_trash;
      WORD    v_ds,       v_ds_trash;
      WORD    v_fs,       v_fs_trash;
      WORD    v_gs,       v_gs_trash;
      } w;

   struct {
      BYTE    p_ds,       p_ds1,        p_ds2,        p_ds3;
      BYTE    p_es,       p_es1,        p_es2,        p_es3;
      BYTE    di,         di1,          edi2,         edi3;
      BYTE    si,         si1,          esi2,         esi3;
      BYTE    bp,         bp1,          ebp2,         ebp3;
      BYTE    extra,      extra1,       extra2,       extra3;
      BYTE    bl,         bh,           ebx2,         ebx3;
      BYTE    dl,         dh,           edx2,         edx3;
      BYTE    cl,         ch,           ecx2,         ecx3;
      BYTE    al,         ah,           eax2,         eax3;
      BYTE    error_code, error_code1,  error_code2,  error_code3;
      BYTE    ip,         ip1,          eip2,         eip3;
      BYTE    cs,         cs1,          cs2,          cs3;
      BYTE    flags,      flags1,       eflags2,      eflags3;
      BYTE    sp,         sp1,          esp2,         esp3;
      BYTE    ss,         ss1,          ss2,          ss3;
      BYTE    v_es,       v_es1,        v_es2,        v_es3;
      BYTE    v_ds,       v_ds1,        v_ds2,        v_ds3;
      BYTE    v_fs,       v_fs1,        v_fs2,        v_fs3;
      BYTE    v_gs,       v_gs1,        v_gs2,        v_gs3;
      } b;

   } INTFRAME;

// Generic declaration for interrupt subfunctions
typedef void SUBFUN(INTFRAME *fr);

void call_BIOS(INTFRAME *before, INTFRAME *after, int number, char ah);
void call_V86(INTFRAME *before, INTFRAME *after);

