; int16.asm  Handle interrupt 16h
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

	GLOBAL	_get_key
	GLOBAL	_check_key

; int get_key(void)
; int check_key(void)

; int16.asm contains three routines.
;
; get_key and check_key are wrappers for int 16h to make it easy for a C
; routine to call (functions 0 and 1 of) int 16h.
;
; service_16 is the pmode interrupt service routine for in 16h.
;
;   If the client was running in V86 mode, it simply uses the client stack
; frame to reflect the interrupt back to v86 mode.
;
;   If the client was running in pmode, it must create a new stack frame
; and must copy some registers from the client stack frame to the new frame.
; Then it calls the BIOS using the new stack frame, and finally copies some
; registers back.
;
;   If we supported pmode use of any int 16h functions that required pointers,
; the process of copying registers would also need to deal with translation of
; pointer formats.  Standard int 16h functions do not require pointers, so we
; don't deal with that.  As a result of this design, nonstandard int 16h
; functions requiring pointers could be called by V86 mode clients, but not by
; pmode clients.
;
;   For V86 mode clients all registers are passed to and from the BIOS int 16h.
; For pmode clients, only eax,ebx and ecx are passed to the BIOS and only eax,
; ebx and the low byte of flags are passed back.  This is enough for all
; standard int 16h functions.

	%include "intframe.inc"
	%include "idt.inc"
	%include "gdt.inc"

	SEGMENT	CODE	USE32

	extern	idt
	extern  FLAT_CODE
	extern	v86_revector
	extern	_call_BIOS

	SEGMENT	CODE

_get_key:
	xor	eax, eax
	int	16h
	ret

_check_key:
	xor	eax, eax
	mov	ah, 1
	int	16h
	jnz	.1
	xor	eax, eax			;Make sure it's really zero
.1:	ret

service_16:
patch_vec 0x16, service_16, D_TRAP+D_DPL3	;Patch vector to point here

	INT_ENTRY	eax
	mov	ebp, esp
	test	byte [fr.flags+2+ebp], 2	;Client in V86 mode
	jz	.pmode				;No
	mov	eax, [0x16 * 4]			;Yes: easy to revector
	jmp	v86_revector

.pmode:	sub	esp, fr_size			;Allocate another frame
	mov	edi, esp			;EDI points to new frame
	mov	eax, [fr.eax+ebp]		;Pass just eax,ebx,ecx to BIOS
	mov	ebx, [fr.ebx+ebp]
	mov	ecx, [fr.ecx+ebp]
	mov	[fr.eax+edi], eax
	mov	[fr.ebx+edi], ebx
	mov	[fr.ecx+edi], ecx
	movzx	eax, ah				;Subfunction
	push	eax				;call_BIOS(&fr, &fr, 0x16, ah)
	push	byte 0x16
	push	edi
	push	edi
	call	_call_BIOS

	mov	eax, [fr.eax+edi]		;Return eax,ebx and flags
	mov	ebx, [fr.ebx+edi]
	mov	cl, [fr.flags+edi]
	mov	[fr.eax+ebp], eax
	mov	[fr.ebx+ebp], ebx
	mov	[fr.flags+ebp], cl

	mov	esp, ebp
	INT_EXIT
