; int.asm  Sample interrupt service routines for V86CALL
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

	%include "intframe.inc"
	%include "idt.inc"
	%include "gdt.inc"

	SEGMENT	CODE	USE32

	extern	idt
	extern  FLAT_CODE
	extern	v86_revector
	extern	_B8000

	SEGMENT	CODE

service_1C:
patch_vec 0x1C, service_1C, D_TRAP+D_DPL3		;Patch vector to point here

; The BIOS timer interrupt calls here.
;
; Temporary kludge, we increment the top left corner of the screen
; to show that the timer is running

	INT_ENTRY	eax
	inc	word [_B8000]
	INT_EXIT

service_40:
patch_vec 0x40, service_40, D_TRAP+D_DPL3		;Patch vector to point here

; The BIOS int 13h calls here.
;
; For now, we assume that is the only thing it could be
; and we give control back to the BIOS

	INT_ENTRY	eax
	mov	ebp, esp
	mov	eax, [0x40 * 4]
	jmp	v86_revector

service_15:
patch_vec 0x15, service_15, D_INT+D_DPL3		;Patch vector to point here

; The BIOS int 13h calls here.
;
; For now, we assume that is the only thing it could be
; and we give control back to the BIOS

	INT_ENTRY	eax
	mov	ebp, esp
	mov	eax, [0x15 * 4]
	jmp	v86_revector
