; gpf.asm  Handle general protection faults
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________

	%include "intframe.inc"
	%include "idt.inc"
	%include "gdt.inc"

	SEGMENT	CODE	USE32

	extern	idt
	extern  FLAT_CODE
	extern	stack_dump

	SEGMENT	CODE
;
; Here is the GPF handler.  We find the code that caused the GPF and
; look it up in a table of things we emulate, then jmp to the routine
; that does the emulation.  If we don't match the instruction we go
; to the stack dump routine.
;_____________________________________________________________________________
service_0D:
patch_vec 0xD, service_0D, D_INT		;Patch vector to point here
	INT_ENTRY
	mov	ebp, esp

	test	byte [fr.flags+2+ebp], 2	;Was it in V86 mode
	jz	fail_0D				;No: abort, don't yet support
						;any nonV86 GPF's

	movzx	ebx, word [fr.cs+ebp]		;Segment of faulting instr
	shl	ebx, 4
	add	ebx, [fr.eip+ebp]		;Linear address
	mov	ecx, tbl_0D			;Table of instructions
	mov	ebx, [ZERO+ebx]			;Faulting instr

;  The following code searches a table of masks and values to find out if
;  the instruction we found matches an instruction we want to service.

.loop:	mov	eax, [ecx]			;Mask
	and	eax, ebx
	cmp	eax, [ecx+4]			;Check masked result
	lea	ecx, [ecx+12]
	jne	.loop				;Not matched yet
	jmp	[ecx-4]				;Matched: Go do it

[SEGMENT CONST]

; Here is a table of some of the instructions you might want to emulate in you
; are supporting V86 mode code.  Note the sw_int and sw_int3 entries are only
; needed when DPL prevents the direct service routine from being used

	align	4
tbl_0D	dd	     0xFF,       0xCD,   sw_int
	dd	     0xFF,       0xCC,   sw_int3
	dd	   0xFFFF,     0x090F,   wb_invd
	dd	   0xFFFF,     0x080F,   _invd
	dd	 0xFFFFFF,   0xC0200F,   mov_reg_cr0
	dd	 0xFFFFFF,   0xC0220F,   mov_cr0_reg
	dd           0xFF,       0xEE,   out_dx_al
	dd	        0,          0,   fail_0D
__SECT__

sw_int:
sw_int3:
out_dx_al:
		;Haven't written these yet

fail_0D:
	mov	eax, 0xD
	jmp	stack_dump

mov_reg_cr0:
	call	get_reg			;Point at client reg within stack frame
	mov	eax, cr0		;Get cr0
	mov	[ecx], eax		;Set client reg
	jmp short done

mov_cr0_reg:
; Let V86 mode code mess with the cache control bits of cr0, but not
; with bits 0 or 31.  Do a wbinvd in case they do mess with cache control.
;
	call	get_reg			;Point at client reg within stack frame
	mov	eax, [ecx]
	or	eax, 80000001h
	wbinvd
	mov	cr0, eax
	jmp short done

_invd:
;  When they ask for invd, give them wbinvd instead

wb_invd: wbinvd

done:	INT_EXIT

get_reg:
;
;Purpose:
;	Get address of client register in stack frame
;Input:
;	EBX bits 16-18: register number
;       EBP:  Interrupt entry stack frame
;Output:
;	ECX  pointer to selected register in stack frame
;Clobbers:
;	EBX
;_____________________________________________________________________________

	shr	ebx, 16-2	  ;Shift reg bits to desired bits
	and	ebx, byte 7*4	  ;Isolate reg bits
	lea	ecx, [fr.eax+ebp] ;Point at reg zero in stack frame
; This next trick works for all but esp.  No one should have used esp, but
; if you want to cover that, use a table lookup here instead.
	sub	ecx, ebx
	ret
