// getpoint.c  Convert client address to kernel flat pointer
// Version 2.0, Sep 12, 1999
// Sample code
// by John S. Fine  johnfine@erols.com
// I do not place any restrictions on your use of this source code
// I do not provide any warranty of the correctness of this source code
//_____________________________________________________________________________

#include "intframe.h"
#include "descript.h"

extern DESCRIPTOR gdt[];

void *get_pointer(INTFRAME *fr, int sreg, DWORD offset) {
//
// Converts a sreg selection and an offset into a linear address.
//
// fr points to the client's frame.
//
// sreg = 0 for ds, 1 for es, 2 for ss or 3 for cs
//
// ds and es are in v_ds and v_es for V86 clients, otherwise in p_ds and p_es
//
// offset is truncated to 16 bits always for V86, but otherwise based on
// the ss attributes when ss is used and cs attributes for other sregs

   DESCRIPTOR *cs;
   DESCRIPTOR *xs;

   if (fr->b.eflags2 & 2)   // V86 mode
      return ( (void *)
         (offset & 0xFFFF) +
         ( ( (sreg==3) ? fr->w.cs :
               ( (sreg==2) ? fr->w.ss :
                  ( (sreg) ? fr->w.v_es : fr->w.v_ds ) ) ) << 4 )
         );
   if (sreg == 2) {
      cs = xs = gdt_entry(fr->d.ss);
      }
   else {
      xs = gdt_entry(
         ( (sreg==3) ? fr->d.cs : ( (sreg) ? fr->d.p_es : fr->d.p_ds ) ) );
      cs = gdt_entry(fr->d.cs);
      }
   if ( ! is_D_BIG(*cs) )
      offset &= 0xFFFF;
   return ( (void *) (seg_base(*xs)+offset) );
   }     
