; dump2.asm  Stack dump in case of failure
; Version 2.0, SEP 12, 1999
; Sample code
; by John S. Fine  johnfine@erols.com
; I do not place any restrictions on your use of this source code
; I do not provide any warranty of the correctness of this source code
;_____________________________________________________________________________
;
;  The page_fault routine in this module is designed to be hooked as the int
;  0xE handler in test versions of pmode projects.  No recoverable page faults
;  are supported.  Here I assume all page faults are unrecoverable errors (and
;  elsewhere, I force most unrecoverable errors to be page faults).
;_____________________________________________________________________________

  GLOBAL  page_fault
  GLOBAL  stack_dump

%include "intframe.inc"

  extern  _B8000	;The display is at 0xB8000 in most systems, I use a
			;link time constant to support other values.  (A
			;product, rather than a sample, should have a
			;run time variable for this).

  extern  FLAT_CODE	;Code selector
  extern  _get_pointer

; The following constant is defined in the .lnk file.  It combines the
; important bits from the constants FLAT_CODE and UNMAPPED_PAGE4IDT
;_____________________________________________________________________________
  extern  UNMAPPED_VAL4IDT

SEGMENT CODE USE32

page_fault:
;
;  Every page fault comes here.  Every unsupported interrupt goes to unmapped
;  memory and triggers a page fault.  First we figure out which happened,
;  then we push registers and dump the stack.
;
;  The stack dump figures out whether the failure occurred in pmode or v86
;  mode and whether there is an error code on the stack.  It labels the
;  locations of registers on the stack accordingly.
;
;  After the main stack dump it displays a column headed by the linear
;  address of the interrupted code, and containing dwords fetched from
;  that address.
;
;  Last it gives a column of either the V86 stack or more of the pmode
;  stack.
;_____________________________________________________________________________

	INT_ENTRY				;Set up stack frame assuming
	mov	ebp, esp			;  this is a real page fault.
	mov	eax, 0xE			;Page fault is int 0xE

	cmp dword [fr.ip+2+ebp], UNMAPPED_VAL4IDT  ;Was this page fault caused
						   ;  by an unsupported
						   ; interrupt?
	jne	stack_dump			;No
	movzx	eax, byte [fr.ip+ebp]		;Yes: Get the interrupt number

; The page fault after the unsupported interrupt pushed 4 extra dwords on the
; stack.  We need to remove those.  However, only interrupts 8, and 0xA - 0xE
; have error codes.  If the interrupt is anything else, we must just remove
; three dwords, because of the missing error code.

	lea	esi, [fr.error_code-4+ebp]	;Last word to move
	lea	edi, [esi+16]			;Destination, if we must
						;  remove 16 bytes.
	cmp	al, 8
	je	.remove				;Remove 16 bytes
	cmp	al, 0xA
	jb	.remove12			;Remove only 12 bytes
	cmp	al, 0xE
	jbe	.remove				;Remove 16 bytes
.remove12:
	or	dword [edi], byte -1		;Create dummy error code of -1
	sub	edi, byte 4			;Correct destination
.remove:
	mov	ecx, fr.error_code/4		;Number of dwords to copy
	std					;Last first
	rep movsd				;Copy them
	lea	esp, [edi+4]			;Point at corrected stack frame
	mov	ebp, esp

DBLN	equ	21			;Number of lines to display

stack_dump:
;  The stack dump should be the absolute end of the line.  If we somehow get
;  here again, something is very wrong.  The first instruction changes itsef
;  to a JMP $ so that it will hang on the second time around.
;_____________________________________________________________________________
	mov word [$], 0xFEEB
	cld
	push	eax			;Vector number
	mov	edi, _B8000		;Point at display
	mov	esi, reg_list		;List of register names
	mov	ebx, esp		;Point at stack contents
	mov	dl, DBLN		;Lines to display
	mov	dh, 0
.1:	mov	eax, ebx		;Display address
	call	hex8
	mov	eax, [ebx]		;Display contents
	call	hex8
	add	ebx, byte 4		;Next address
	mov	cl, [0x44A]		;Screen width
	sub	cl, 18			;Minus 18 characters used
	cmp byte [esi], al		;Past end of reg_list?
	jz	.5			;Yes
	test byte [fr.flags+2+ebp], 2	;V86 mode ?
	jz	.3			;No
	cmp	esi, p_ds		;pmode only reg?
	jb	.4			;No
	cmp	esi, p_es		;...
	ja	.4			;No
	add	esi, 3			;Yes, skip it
	jmp short .5

.3:	cmp	esi, vregs		;Reg only valid for V86
	jae	.5			;Yes:  Done with names
	cmp word [fr.cs+ebp], FLAT_CODE	;In kernel?
	jnz	.4			;No
	cmp	esi, rregs		;Reg only valid if ring transition?
	jae	.5			;Yes:  Done with names

.4:	lodsb				;Display register name
	stosw
	test	al, al			;  null terminated
	loopnz	.4
.5:	rep stosw			;Clear to start of next line
	dec	dl			;Count lines
	jnz near .1

	mov	edi, _B8000+50		;Prepare to show some of 
	mov	esi, ebx		; client's stack
	cmp word [fr.cs+ebp], FLAT_CODE	;In kernel?
	je	.20			;Yes: just show more of kern stack
	push	dword [fr.esp+ebp]	; get_pointer(fr, 2, fr.esp)
	push	byte 2
	push	ebp
	call	_get_pointer
	xchg	eax, esi		;ESI points at client stack
.20:	call	hexlist

	mov	edi, _B8000+74		;Show some of client's code
	push	dword [fr.eip+ebp]	; get_pointer(fr, 3, fr.eip)
	push	byte 3
	push	ebp
	call	_get_pointer
	xchg	eax, esi		;ESI points at client code
	call	hexlist
	
.99:	jmp short $			;Hang


hexlist:
;Purpose:
;	Display a column of values headed by the address
;Inputs:
;	esi address
;	edi display pointer
;Outputs:
;	edi advanced
;	esi advanced
;	ecx zero
;       dl  zero
;	eax 0x????0700
;_____________________________________________________________________________

	mov	eax, esi		;Address
	call	hex8			;Display the address
	mov	cl, [0x44A]		;Screen width
	lea	edi, [edi+ecx*2]	;Down one line
	mov	dl, DBLN-2		;Total lines minus two
.10:	mov	cl, [0x44A]		;Screen width
	lea	edi, [edi+ecx*2-18]	;Down another line and left the
					; width of what hex8 just displayed
	lodsd				;Value
	call	hex8			;Display the value
	dec	dl			;Count lines
	jnz	.10			;Until done
	ret

hex8:
;Purpose:
;	Converts value of eax in hex into display buffer pointed to by edi
;Inputs:
;	eax value
;	edi display pointer
;Outputs:
;	edi advanced
;	ecx zero
;	ax  0x700
;_____________________________________________________________________________

	mov	ecx, 8		;Count eight digits
.1:	rol	eax, 4		;Next digit
	push	eax		;Save
	and	al, 0xF		;Convert nibble to hex ascii
	cmp	al, 10
	sbb	al, 0x69
	das
	mov	ah, 7		;Default screen attribute
	stosw			;Store it and advance edi
	pop	eax		;Restore
	loop	.1		;Eight digits
	mov	ax, 0x700	;Invisible character, default attribute
	stosw			;Store it and advance edi
	ret			;Return

SEGMENT DATA
reg_list db	"INT",0		;Names for items in the stack dump
p_ds:	db	"ds",0
p_es:	db	"es",0
	db	"edi",0
	db	"esi",0
	db	"ebp",0
	db	"esp",0
	db	"ebx",0
	db	"edx",0
	db	"ecx",0
	db	"eax",0
	db	"error",0
	db	"eip",0
	db	"cs",0
	db	"flags",0
rregs:
	db	"esp",0
	db	"ss",0
vregs:
	db	"es",0
	db	"ds",0
	db	"fs",0
	db	"gs",0
	db	0		;Extra null terminates list

