// descript.h  Structure and fast access macros for GDT, IDT and LDT descriptors
// Version 2.0, Sep 12, 1999
// Sample code
// by John S. Fine  johnfine@erols.com
// I do not place any restrictions on your use of this source code
// I do not provide any warranty of the correctness of this source code
//_____________________________________________________________________________
//
// typedef ... DESCRIPTOR defines a union giving several different views of
// the 64-bit structure used for descriptors.
//
// The primary views .g and .s give the actual shape of a descriptor in its
// two possible formats (gate and nongate).
//
// The other views make it easier to reassemble the values (base, limit and
// offset) that are fragmented in the Intel descriptor design
//_____________________________________________________________________________

#define PACKED __attribute__((packed))  // Used to keep the GNU C compiler from
                                        // padding these structures

typedef union {
   struct {    // gate
      WORD offset0_15;
      WORD selector;
      WORD attr0_15;
      WORD offset16_31;
      } g;
   struct {    // segment (and other nongate descriptors)
      WORD limit0_15;
      WORD base0_15;
      BYTE base16_23;
      BYTE attr8_15;
      BYTE _attr4_7;  // includes limit16_19
      BYTE base24_31;
      } s;
   struct {    // faster access to base0_23
      WORD limit0_15;
      DWORD _base0_23;
      } PACKED s1;
   struct {    // faster access to limit16_19
      WORD limit0_15;
      DWORD _limit16_19;
      } PACKED s2;
   struct {    // viewed as two DWORDs
      DWORD lo;
      DWORD hi;
      } d;
   } DESCRIPTOR;

#define gate_offset(x) ( ((x).d.hi & 0xFFFF0000) + (x).g.offset0_15 )
#define seg_base(x) ( ((x).d.hi & 0xFF000000) + ((x).s1._base0_23 & 0xFFFFFF) )
#define seg_lim(x)  ( ((x).s2._limit16_19 & 0xF0000) + (x).s.limit0_15 )

#define D_BIG 0x40
#define is_D_BIG(x) ( (x).s._attr4_7 & D_BIG )

#define gdt_entry(x) ((DESCRIPTOR *)( (char *)gdt + ((x)&(~7)) ) )
