/*****************************************************************************
Patches bug in WSOCK2.VXD that prevents recv() and send() working
when called from 16-bit mode (virtual-8086 mode DOS box)

USE THIS PROGRAM AT YOUR OWN RISK.

You can specify the Windows directory on the command line, e.g.
	ws2patch c:\win
Otherwise, this program will attempt to find the Windows directory itself.

Copyright (C) 2003 by Chris Giese
<geezer@execpc.com>, http://my.execpc.com/~geezer

Based on Berci Gabor's information
http://www.phekda.freeserve.co.uk/gabor/ws2dos/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************************/
#include <sys/stat.h> /* (Turbo C) S_... */
#include <stdlib.h> /* getenv(), malloc(), free() */
#include <string.h> /* strcpy(), strcat(), memcmp() */
/* fopen(), fseek(), ftell(), fread(), fclose() */
#include <stdio.h> /* FILE, SEEK_END, SEEK_SET, printf() */
#include <conio.h> /* getch() */
#include <fcntl.h> /* (DJGPP) S_... */
#include <io.h> /* chmod() */
/*****************************************************************************
*****************************************************************************/
int main(int arg_c, char *arg_v[])
{
	char bad_data[] =
		"\x01\x01\x00\x01\x01\x01\x01\x00\x00\x04\x03\x03\x00\x03";
	char good_data[] =
		"\x01\x01\x00\x01\x01\x01\x01\x00\x00\x03\x03\x03\x00\x02";
	char *s, vxd_file[128], backup_file[128], *wad;
	unsigned i, len, here;
	FILE *f;

/* Hmmm. Do those zero bytes in the initializers
cause the arrays to be shortened? */
	if(sizeof(bad_data) != 15 || sizeof(good_data) != 15)
	{
		printf("sizeof() error\n");
		return 1;
	}
	printf("This program will patch a bug in WSOCK2.VXD\n"
		"Do you want to continue (y/n)?\n");
	i = getch();
	if(i == 0)
		i = 0x100 | getch();
	if(i != 'y' && i != 'Y')
		return 1;
/* find Windows directory */
	if(arg_c == 2)
	{
		printf("Looking for Windows in '%s'...\n", arg_v[1]);
		strcpy(vxd_file, arg_v[1]);
	}
	else
	{
		s = getenv("windir");
		if(s != NULL)
			strcpy(vxd_file, s);
		else
		{
			printf("No 'windir' environment variable. "
				"I assume Windows is in \\WINDOWS...\n");
			strcpy(vxd_file, "\\WINDOWS");
		}
	}
/* find WSOCK2.VXD and open it */
	strcat(vxd_file, "\\SYSTEM\\WSOCK2.VXD");
	f = fopen(vxd_file, "rb");
	if(f == NULL)
	{
		printf("Can't open Winsock2 VxD file '%s'\n", vxd_file);
		return 1;
	}
/* get size of file and allocate memory */
	fseek(f, 0, SEEK_END);
	len = (unsigned)ftell(f);
	fseek(f, 0, SEEK_SET);
	printf("File length is %u bytes\n", len);
	wad = malloc(len);
	if(wad == NULL)
	{
		printf("Out of memory (wanted %u bytes)\n", len);
		fclose(f);
		return 1;
	}
/* read entire file into memory and close it */
	i = fread(wad, 1, len, f);
	fclose(f);
	if(i != len)
	{
		printf("Error reading file '%s'\n", vxd_file);
		free(wad);
		return 1;
	}
/* find the bad code */
	for(here = 0; here < len - sizeof(bad_data) - 1; here++)
	{
		if(!memcmp(wad + here, bad_data, sizeof(bad_data) - 1))
			goto FOUND;
	}
	printf("Didn't find bad data in WSOCK2.VXD (good!)\n");
	free(wad);
	return 0;
FOUND:
	printf("Found bad data at file offset %u\n", here);
/* backup the file */
	strcpy(backup_file, vxd_file);
	s = strstr(backup_file, ".VXD");
	if(s == NULL)
	{
		printf("Software error!\n"); /* "can't happen" */
		free(wad);
		return 1;
	}
	strcpy(s, ".BAK");
	f = fopen(backup_file, "wb");
	if(f == NULL)
	{
		printf("Can't create backup file '%s'\n", backup_file);
		free(wad);
		return 1;
	}
	printf("Writing backup file...\n");
	i = fwrite(wad, 1, len, f);
	fclose(f);
	if(i != len)
	{
		printf("Error writing backup file '%s'\n", backup_file);
		free(wad);
		return 1;
	}
/* WS2 upgrade to Win95 leaves this file read-only */
	printf("Making VxD file writable...\n");
	if(chmod(vxd_file, S_IWRITE | S_IREAD) != 0)
	{
		printf("FAILED. Try using 'attrib -r %s'\n", vxd_file);
		free(wad);
		return 1;
	}
/* patch it */
	printf("Patching...\n");
	memcpy(wad + here, good_data, sizeof(good_data) - 1);
	f = fopen(vxd_file, "wb");
	if(f == NULL)
	{
		printf("Can't open file '%s' for writing\n", vxd_file);
		free(wad);
		return 1;
	}
	i = fwrite(wad, 1, len, f);
	fclose(f);
	if(i != len)
	{
		printf("Error writing file '%s'\n", vxd_file);
		free(wad);
		return 1;
	}
	free(wad);
	printf("Success!\n");
	return 0;
}
