/*****************************************************************************
Simple TCP (stream; HTTP) server

This code is public domain (no copyright).
You can do whatever you want with it.
*****************************************************************************/
#include <stdlib.h> /* atexit() */
#include <string.h> /* memset() */
#include <stdio.h> /* printf() */

#if defined(__WIN32__)
#include <winsock.h>
#include <conio.h> /* kbhit(), getch() */

#elif defined(linux)
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>

#define	closesocket(S)	close(S)

static int kbhit(void);
static int getch(void);

#elif defined(__TURBOC__)
#include <conio.h>
#include "socket.h"

#elif defined(__WATCOMC__)
#if defined(__386__)
#error This is a 16-bit program
#endif
#include <conio.h>
#include "socket.h"

#else
#error Unsupported OS or compiler
#endif

#define	MY_PORT		80 /* HTTP */
#define	MY_BACKLOG	5
#define	MY_BUF_SIZE	256
/*****************************************************************************
*****************************************************************************/
int main(void)
{
	static const char greet[] =
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n"
		"<TITLE>H E L L O !</TITLE>\n"
		"<BODY><H1>Hello!</H1>\n";
/**/
	struct sockaddr_in my_adr;
	int l_sock, i, count;
#if defined(__WIN32__)
	WSADATA wsdata;

/* Winsock start up */
	WSAStartup(0x0101, &wsdata);
	atexit((void (*)(void))WSACleanup);
#endif
/* create listener socket */
printf("calling socket()...\n");
	l_sock = socket(AF_INET, SOCK_STREAM, 0);
	if(l_sock < 0)
	{
		printf("socket() failed; errno=%d\n", errno);
		return 1;
	}
/* bind to port */
printf("calling bind()...\n");
	memset(&my_adr, 0, sizeof(my_adr));
	my_adr.sin_family = AF_INET;
	my_adr.sin_port = htons(MY_PORT);
	my_adr.sin_addr.s_addr = INADDR_ANY;
	i = bind(l_sock, (struct sockaddr *)&my_adr,
		sizeof(struct sockaddr));
	if(i < 0)
	{
		printf("bind() failed; errno=%d\n", errno);
		closesocket(l_sock);
		return 1;
	}
/* listen on it */
printf("calling listen()...\n");
	i = listen(l_sock, MY_BACKLOG);
	if(i < 0)
	{
		printf("listen() failed; errno=%d\n", errno);
		closesocket(l_sock);
		return 1;
	}
/* loop until key pressed... */
	printf("HTTP server running, please visit http://localhost    :)\n"
		"Press a key to exit...\n");
	count = 1;
	while(!kbhit())
	{
		struct sockaddr_in their_adr;
		char buf[MY_BUF_SIZE];
		int sin_size, c_sock;
		struct timeval timeout;
		fd_set read_handles;

/* use select() to avoid blocking */
		FD_ZERO(&read_handles);
		FD_SET(l_sock, &read_handles);
		timeout.tv_sec = timeout.tv_usec = 0;
		i = select(l_sock + 1, &read_handles, NULL, NULL, &timeout);
		if(i < 0)
		{
			printf("select(l_sock) failed; errno=%d\n", errno);
			break;
		}
/* nothing yet */
		if(i == 0)
			continue;
printf("calling accept()\n");
/* accept a connection from a client
This function can block */
		sin_size = sizeof(struct sockaddr_in);
		c_sock = accept(l_sock,
			(struct sockaddr *)&their_adr, &sin_size);
/* with other Winsock code (actually with a DOS program calling WSOCK2.VXD)
accept() returns -1 immediately if no connection yet. There's probably a
setsockopt() option to enable such behavior because, without the select()
above, accept() DOES block in this code. */
		if(c_sock < 0 && errno == 0)
			continue;
		if(c_sock < 0)
		{
			printf("accept() failed; errno=%d\n", errno);
			break;
		}
/* someone's there */
		printf("connection from %s\n",
			inet_ntoa(their_adr.sin_addr));
/* do they have anything to say?
xxx - do this instead:
	fcntl(c_sock, F_SETFL, O_NONBLOCK);
then recv() will return -1 and set errno to EWOULDBLOCK
if there's no data */
		FD_ZERO(&read_handles);
		FD_SET(c_sock, &read_handles);
		timeout.tv_sec = timeout.tv_usec = 0;
		i = select(c_sock + 1, &read_handles, NULL, NULL, &timeout);
		if(i < 0)
		{
			printf("select(c_sock) failed; errno=%d\n", errno);
			break;
		}
/* yes; read and display their message */
		if(i > 0)
		{
			i = recv(c_sock, buf, MY_BUF_SIZE - 1, 0);
			if(i < 0 && errno != 0)
			{
				printf("recv() failed; errno=%d\n", errno);
				break;
			}
			if(i > 0)
			{
				buf[i] = '\0';
				printf("incoming message:\n/**********************"
					"**********************************\n%s"
					"\\****************************************"
					"****************\n", buf);
			}
		}
/* send packet */
		sprintf(buf, "HTTP/1.0 200 OK\r\n"
			"Content-Type: text/html\r\n"
			"\r\n"
			"%sThis page has been viewed "
			"<B>%u</B> time(s)\n", greet, count);
		count++;
		i = send(c_sock, buf, strlen(buf), 0);
/* close socket */
		closesocket(c_sock);
		if(i < 0 && errno != 0)
		{
			printf("send() failed; errno=%d\n", errno);
			break;
		}
		printf("Sent %d bytes\n", i);
	}
	closesocket(l_sock);
	return 0;
}
/*----------------------------------------------------------------------------
fake kbhit() and getch() for Linux/UNIX
----------------------------------------------------------------------------*/
#if defined(linux)

#include <sys/time.h> /* struct timeval, select() */
/* ICANON, ECHO, TCSANOW, struct termios */
#include <termios.h> /* tcgetattr(), tcsetattr() */
#include <stdlib.h> /* atexit(), exit() */
#include <unistd.h> /* read() */
#include <stdio.h> /* printf() */

static struct termios g_old_kbd_mode;
/*****************************************************************************
*****************************************************************************/
static void cooked(void)
{
	tcsetattr(0, TCSANOW, &g_old_kbd_mode);
}
/*****************************************************************************
*****************************************************************************/
static void raw(void)
{
	static char init;
/**/
	struct termios new_kbd_mode;

	if(init)
		return;
/* put keyboard (stdin, actually) in raw, unbuffered mode */
	tcgetattr(0, &g_old_kbd_mode);
	memcpy(&new_kbd_mode, &g_old_kbd_mode, sizeof(struct termios));
	new_kbd_mode.c_lflag &= ~(ICANON | ECHO);
	new_kbd_mode.c_cc[VTIME] = 0;
	new_kbd_mode.c_cc[VMIN] = 1;
	tcsetattr(0, TCSANOW, &new_kbd_mode);
/* when we exit, go back to normal, "cooked" mode */
	atexit(cooked);

	init = 1;
}
/*****************************************************************************
*****************************************************************************/
static int kbhit(void)
{
	struct timeval timeout;
	fd_set read_handles;
	int status;

	raw();
/* check stdin (fd 0) for activity */
	FD_ZERO(&read_handles);
	FD_SET(0, &read_handles);
	timeout.tv_sec = timeout.tv_usec = 0;
	status = select(0 + 1, &read_handles, NULL, NULL, &timeout);
	if(status < 0)
	{
		printf("select() failed in kbhit()\n");
		exit(1);
	}
	return status;
}
/*****************************************************************************
*****************************************************************************/
static int getch(void)
{
	unsigned char temp;

	raw();
/* stdin = fd 0 */
	if(read(0, &temp, 1) != 1)
		return 0;
	return temp;
}
#endif

