;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Socket library for Turbo C and 16-bit Watcom C that calls WSOCK[2].VXD
;
; This code must be run inside a Windows 9x DOS box, preferably Win95
; (WinSock version 1). It will not work in a Windows NT/2k/XP DOS box.
;
; Copyright (C) 2003 by Chris Giese
; <geezer@execpc.com>, http://my.execpc.com/~geezer
;
; Based on Berci Gabor's Turbo Pascal code for accessing WSOCK2.VXD
; http://www.phekda.freeserve.co.uk/gabor/ws2dos/
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;
; Assemble with NASM:
;	nasm -f obj callsock.asm
;
; EXPORTS:
; extern char g_wsock2;
; int call_wsock_vxd(unsigned fn, void FAR *params, unsigned size);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; IMPORTS
; from C library (CS.LIB)

%ifdef __WATCOMC__
EXTERN atexit_
%else
EXTERN _atexit
%endif

SEGMENT _TEXT PUBLIC CLASS=CODE
SEGMENT _DATA PUBLIC CLASS=DATA
SEGMENT _BSS PUBLIC CLASS=BSS
SEGMENT _BSSEND PUBLIC CLASS=BSSEND

%ifdef TINY
GROUP DGROUP _TEXT _DATA _BSS _BSSEND

%else
GROUP DGROUP _DATA _BSS _BSSEND
%endif

SEGMENT _TEXT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			unload_wsock
; action:		unloads WSOCK[2].VXD
; in:			(nothing)
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		386+
; notes:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_unload_wsock:
	push bp
	    mov bp,sp
	    push dx
	    push ax
		mov dx,wsock2_vxd_name
		test byte [_g_wsock2],0FFh
		jne uw_1
		mov dx,wsock1_vxd_name
uw_1:
		mov ax,2
		call far [vxdldr_entry]
	    pop ax
	    pop dx
	pop bp
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			call_wsock_vxd
; action:		calls WSOCK.VXD or WSOCK2.VXD in V86 mode
; in:			args on stack per C prototype
; out (error):		AX != 0
; out (OK):		AX == 0
; modifies:		AX
; minimum CPU:		386+
; notes:		C prototype:
;	int call_wsock_vxd(unsigned fn, void FAR *params, unsigned size);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

GLOBAL _call_wsock_vxd
_call_wsock_vxd:
	push bp
	    mov bp,sp
	    push es
	    push di
	    push dx
	    push bx

; WSOCK[2].VXD loaded yet?
		test word [wsock_entry + 2],0FFFFh
		jne cwv_2

; get entry point of VXDLDR.VXD
		xor di,di
		mov es,di
		mov bx,0027h	; =INT 2Fh AX=1684h ID for VXDLDR.VXD
		mov ax,1684h
		int 2Fh
		mov ax,es
		or ax,di
		mov ax,0FFFFh
		je cwv_3
		mov [vxdldr_entry + 0],di
		mov [vxdldr_entry + 2],es

; try loading WSOCK2.VXD
		mov byte [_g_wsock2],1
		mov bx,3B0Ah	; =INT 2Fh AX=1684h ID for WSOCK2.VXD

		mov dx,wsock2_vxd_name
		mov ax,1
		call far [vxdldr_entry]
		or ax,ax
		je cwv_1

; that didn't work; try loading WSOCK.VXD
		mov byte [_g_wsock2],0
		mov bx,003Eh	; =INT 2Fh AX=1684h ID for WSOCK.VXD

		mov dx,wsock1_vxd_name
		mov ax,1
		call far [vxdldr_entry]
		or ax,ax
		jne cwv_3
cwv_1:
; get entry point of WSOCK[2].VXD
		xor di,di
		mov es,di
		mov ax,1684h
		int 2Fh
		mov ax,es
		or ax,di
		mov ax,0FFFFh
		je cwv_3
		mov [wsock_entry + 0],di
		mov [wsock_entry + 2],es

; unload WSOCK[2].VXD when exiting
%ifdef __WATCOMC__
		mov ax,_unload_wsock
		call atexit_
%else
		push word _unload_wsock
		    call _atexit
		pop ax
%endif
cwv_2:
		mov ax,[bp + 4]
		les bx,[bp + 6]
		call far [wsock_entry]
cwv_3:
	    pop bx
	    pop dx
	    pop di
	    pop es
	pop bp
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DATA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SEGMENT _DATA

GLOBAL _g_wsock2
_g_wsock2:
	db 0
wsock2_vxd_name:
	db "WSOCK2.VXD", 0
wsock1_vxd_name:
	db "WSOCK.VXD", 0
vxdldr_entry:
	dw 0, 0
wsock_entry:
	dw 0, 0
