;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
[SECTION .text]
[BITS 32]

[GLOBAL _start]
_start:
	mov ds,eax	; EAX works; instruction is 1 byte smaller :)
	mov ss,eax
	nop
	mov es,eax
	mov fs,eax
	mov gs,eax

	sub esi,_start		; ESI=0x00100000 - 0xC0000000

	lea eax,[_gdt + esi]		; physical adr of new GDT
	lea ebx,[_gdt_ptr + esi]	; physical adr of _gdt_ptr
	mov [ebx + 2],eax
	lgdt [ebx]

	lea eax,[__page_dir + esi]	; physical adr of page_dir

[EXTERN _init_paging]
	push eax
		call _init_paging
	pop eax

	mov cr3,eax
	mov eax,cr0
;	or eax,80000000h
;	or eax,80010000h	; set the 486 WP (page write protect) bit
	or eax,0C0010000h	; set the 486 CE (cache enable) and WP bits
	mov cr0,eax
	jmp SYS_CODE_SEL:paging
paging:

	mov ax,SYS_DATA_SEL
	mov ds,eax
	mov ss,eax
	nop
	mov fs,eax
	mov gs,eax

	mov esp,_stack1

[EXTERN _main]
	call _main

	jmp $

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

[GLOBAL _enable_paging]
_enable_paging:
	mov eax,[esp + 4]
	mov cr3,eax
	jmp foo
foo:
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
[SECTION .data]

_gdt_ptr:
	dw _gdt_end - _gdt - 1		; GDT limit
	dd _gdt				; linear adr of GDT (set above)

; null descriptor
_gdt:
	dw 0		; limit 15:0
	dw 0		; base 15:0
	db 0		; base 23:16
	db 0		; type
	db 0		; limit 19:16, flags
	db 0		; base 31:24
; linear data segment descriptor
LINEAR_SEL	equ	$-_gdt
	dw 0FFFFh	; limit 0FFFFFh (1 meg? 4 gig?)
	dw 0		; base for this one is always 0
	db 0
	db 92h		; present,ring 0,data,expand-up,writable
	db 0CFh		; page-granular (4 gig limit), 32-bit
	db 0
; code segment descriptor
SYS_CODE_SEL	equ	$-_gdt
_gdt2:
	dw 0FFFFh
	dw 0		; (base gets set above)
	db 0
	db 9Ah		; present,ring 0,code,non-conforming,readable
	db 0CFh
	db 0
; data segment descriptor
SYS_DATA_SEL	equ	$-_gdt
_gdt3:
	dw 0FFFFh
	dw 0		; (base gets set above)
	db 0
	db 92h		; present,ring 0,data,expand-up,writable
	db 0CFh
	db 0
_gdt_end:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The kernel BSS: page tables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

[SECTION .bss]

[GLOBAL __page_dir]
__page_dir:
	resb 4096	; the kernel page directory
	resb 4096	; __page_tab0
	resb 4096	; __page_tabK

	resd 1023
_stack1:
	resd 1
