#include <sys/farptr.h> /* _farpokeb() */
#include <string.h> /* movedata() */
#include "_printf.h" /* do_printf() */

#define	LINEAR_SEL	0x08
#define	SYS_DATA_SEL	0x18
#define	VIDEO_OFF	0xB8000L

static unsigned _csr_x, _csr_y;
static unsigned _vc_width = 80, _vc_height = 25;
/*****************************************************************************
*****************************************************************************/
static void scroll(void)
{
	unsigned byte_count, dst;

/* scroll up all but one line of the display */
	byte_count = (_vc_height - 1) * _vc_width * 2;
	movedata(LINEAR_SEL, VIDEO_OFF + _vc_width * 2,
		LINEAR_SEL, VIDEO_OFF + 0,
		byte_count);
/* fill the bottom line with blanks */
	dst = (_vc_height - 1) * _vc_width * 2;
	for(byte_count = _vc_width; byte_count != 0; byte_count--)
	{
		_farpokeb(LINEAR_SEL, VIDEO_OFF + dst, ' ');
		dst += 2;
	}
}
/*****************************************************************************
*****************************************************************************/
static int putch(int c)
{
	unsigned dst;

/* tab to every 8th column */
	if(c == 0x09)
		_csr_x = (_csr_x + 8) & ~(8 - 1);
/* carriage return */
	else if(c == '\r')	/* 0x0D */
		_csr_x = 0;
/* line feed */
//	else if(c == '\n')	/* 0x0A */
//		_csr_y++;
/* CR/LF */
	else if(c == '\n')	/* ### - 0x0A again */
	{
		_csr_x = 0;
		_csr_y++;
	}
/* printable ASCII */
	else if(c >= ' ')
	{
		dst = VIDEO_OFF + (_csr_y * _vc_width + _csr_x) * 2;
		_farpokeb(LINEAR_SEL, dst, c);
		_csr_x++;
	}
/* if cursor goes too far right, wrap down to start of next line */
	if(_csr_x >= _vc_width)
	{
		_csr_x = 0;
		_csr_y++;
	}
/* if cursor goes too far down, scroll up one line */
	if(_csr_y >= _vc_height)
	{
		_csr_y = _vc_height - 1;
		scroll();
	}
	return c;
}
/*****************************************************************************
*****************************************************************************/
static int kprintf_help(char c, void **ptr)
{
	putch(c);
	return 0;
}
/*****************************************************************************
*****************************************************************************/
static void kprintf(const char *fmt, ...)
{
	va_list args;

	va_start(args, fmt);
	(void)do_printf(fmt, args, kprintf_help, NULL);
	va_end(args);
}
/*****************************************************************************
*****************************************************************************/
void dump_page_tables(unsigned long *page_dir)
{
	unsigned long temp, *page_tab;
	unsigned long pde, pte;

	kprintf("page directory at 0x%8lX", page_dir);
/* RAM */
	for(pde = 0; pde < 512; pde++)
	{
		if(page_dir[pde] == 0)
			continue;
		temp = page_dir[pde];
		kprintf("\npage dir[%4u]=0x%8lX",
			pde, temp);
		page_tab = (unsigned long *)(temp & -4096);
/* show only entries 0, 1, and 1023 in the page dir (if they're valid) */
		for(pte = 0; pte < 2; pte++)
		{
			if(page_tab[pte] == 0)
				continue;
			temp = page_tab[pte];
			kprintf("\n    page tab[%4u]=0x%8lX", pte, temp);
		}
		kprintf("\n\t...\n");
		for(pte = 1023; pte < 1024; pte++)
		{
			if(page_tab[pte] == 0)
				continue;
			temp = page_tab[pte];
			kprintf("\n    page tab[%4u]=0x%8lX", pte, temp);
		}
	}
/* kernel memory */
	for(pde = 512; pde < 1024; pde++)
	{
		if(page_dir[pde] == 0)
			continue;
		temp = page_dir[pde];
		kprintf("\npage dir[%4u]=0x%8lX",
			pde, temp);
		page_tab = (unsigned long *)(temp & -4096);
/* show all valid entries */
		for(pte = 0; pte < 1024; pte++)
		{
			if(page_tab[pte] == 0)
				continue;
			temp = page_tab[pte];
			kprintf("\n    page tab[%4u]=0x%8lX", pte, temp);
		}
	}
	kprintf("\n\n");
}









/* starting virtual address of kernel (e.g. 0xC0000000 == 3 gig) */
#define	KVIRT		((unsigned long)&start)
/* where in RAM the kernel is actually loaded */
#define	KPHYS		0x100000L
/* conversion value */
#define	VIRT_TO_PHYS	(KPHYS - KVIRT)

/* get index into page directory from virtual address */
#define	PDI(X)		((X >> 22) & 0x3FF)
/* get index into page table from virtual address */
#define	PTI(X)		((X >> 12) & 0x3FF)

#define	PRIV_PRESENT	0x001
#define	PRIV_WRITABLE	0x002
#define	PRIV_USER	0x004

#define	PRIV_FOO	0x200	/* user-defined (e.g. for COW) */
#define	PRIV_BAR	0x400	/* user-defined */
#define	PRIV_BAZ	0x800	/* user-defined */

#define	PRIV_ALL	0xFFF

/* these are defined in the linker script (COFFKRNL.LD) */
extern char start, etext, edata, end;
/*****************************************************************************
Install page table 'table' into page directory 'dir'. The page table will be
used to map memory from virtual address 'virt' to, at most 'virt' + 4 meg.
Returns -1 if a page table is already installed.
*****************************************************************************/
static int install_page_table(unsigned long *dir, unsigned long table,
		unsigned long virt)
{
	unsigned short dirent;

/* put PHYSICAL address of page table into page dir */
	dirent = PDI(virt);
	if(dir[dirent] != 0)
		return -1;
	dir[dirent] = (table & 0xFFFFF000L) |
		(PRIV_USER | PRIV_WRITABLE | PRIV_PRESENT);
	return 0;
}
/*****************************************************************************
Using the page directory at 'dir', map one page with virtual address
'virt' to physical address 'phys', with permission/privilege bits 'priv'.
Returns -1 if the necessary page table has not been installed.
*****************************************************************************/
static int map_page(unsigned long *dir, unsigned short priv,
		unsigned long virt, unsigned long phys)
{
	unsigned short dirent, tabent;
	unsigned long *tab;

/* got a page table? */
	dirent = PDI(virt);
	if(dir[dirent] == 0)
		return -1;
/* yes, point to PHYSICAL address of page table */
	tab = (unsigned long *)(dir[dirent] & 0xFFFFF000L);
/* map the page */
	tabent = PTI(virt);
	priv &= 0xFFF;
	tab[tabent] = (phys & 0xFFFFF000L) | priv;

	return 0;
}
/*****************************************************************************
Using the page directory at 'dir, map a range of memory from virtual
address 'virt' to physical address 'phys', with permission/privilege
bits 'priv', 'len' bytes total.
Returns -1 if a necessary page table has not been installed.
*****************************************************************************/
static int map_mem(unsigned long *dir, unsigned short priv,
		unsigned long virt, unsigned long phys, unsigned long len)
{
	unsigned long tvirt;

	for(tvirt = virt; tvirt < virt + len; tvirt += 4096)
	{
		if(map_page(dir, priv, tvirt, phys) != 0)
			return -1;
		phys += 4096;
	}
	return 0;
}
/*****************************************************************************
*****************************************************************************/
int init_paging(unsigned long *dir)
{
	unsigned long tab;

/* put _page_tab0 4K above the page directory */
	tab = (unsigned long)dir + 4096;
/* this page table will identity-map the bottom 4 meg of RAM */
	if(install_page_table(dir, tab, 0) != 0)
		return -1;
/* put _page_tabK 8K above the page directory */
	tab = (unsigned long)dir + 8192;
/* this page table will map, at most, 4 meg of kernel memory */
	if(install_page_table(dir, tab, KVIRT) != 0)
		return -1;
/* identity-map the bottom 4 meg of RAM */
	if(map_mem(dir, PRIV_WRITABLE | PRIV_PRESENT, 0, 0, 4194304L) != 0)
		return -1;
/* map kernel code (and, for DJGPP COFF, read-only data).
A decent CPU would also let us map pages Executable or not,
and we would separate code from read-only data (ELF does this). */
	if(map_mem(dir, PRIV_PRESENT,
		(unsigned long)&start,
		(unsigned long)&start + VIRT_TO_PHYS,
		&etext - &start) != 0)
			return -1;
/* map kernel data and BSS */
	if(map_mem(dir, PRIV_WRITABLE | PRIV_PRESENT,
		(unsigned long)&etext,
		(unsigned long)&etext + VIRT_TO_PHYS,
		&end - &etext) != 0)
			return -1;
	return 0;
}
/*****************************************************************************
*****************************************************************************/
extern unsigned long _page_dir[];

int main(void)
{
	kprintf("Hello from address 0x%X in the land of paged "
		"protected mode\n", &start);
	dump_page_tables(_page_dir);
	return 0;
}
