;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Demonstration of INT 15h AH=87h
; (BIOS function to copy to extended memory)
; Chris Giese	<geezer@execpc.com>	http://my.execpc.com/~geezer/
; Release date: Feb 24, 2006
; This code is public domain (no copyright).
; You can do whatever you want with it.
;
; Requires a 256-color .BMP file (currently COW8.BMP)
; and a video card with VBE 2.x and linear framebuffer
;
; Build:
; nasm -f bin -o int1587.com int1587.asm
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	ORG 100h		; DOS .COM file

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Check for VBE 2.x video BIOS, and find a 256-color
; video mode that supports the linear framebuffer (LFB)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	mov ax,4F00h		; check for VBE video BIOS
	;push ds
	;pop es
	mov di,_buf
	int 10h
	cmp ax,004Fh
	je vbe_ok
no_vbe:
	mov si,_no_vbe_msg	; display error message
mexit:
	call puts

	mov ax,4C01h		; exit to DOS with ERRORLEVEL=1
	int 21h
vbe_ok:
	cmp byte [di + 5],2	; want VBE version 2.x or better for LFB
	jb no_vbe
	mov si,[di + 14]	; iterate over list of video modes
	mov es,[di + 16]
	jmp short check_modes_3
check_modes_1:
	push es
		mov di,ds
		mov es,di
		mov di,_mode_buf
		mov ax,4F01h			; get mode info
		int 10h
		cmp ax,004Fh			; mode not supported
		jne check_modes_2
		test byte [es:di + 0],80h	; want linear framebuffer
		je check_modes_2
		cmp byte [es:di + 25],8		; want 256-color mode
		jne check_modes_2
 cmp word [es:di + 18],800	; minimum horizontal resolution
 jb check_modes_2
		jmp short got_mode
check_modes_2:
	pop es
	add si,byte 2
check_modes_3:
	mov cx,[es:si]
	cmp cx,0FFFFh
	jne check_modes_1
	mov si,_no_mode_msg	; no 256-color mode with LFB?
	jmp short mexit

got_mode:
		mov [_mode_num],cx
	add sp,2
	push ds
	pop es

	xor dx,dx		; display mode info
	mov bx,16		; (in hex)
	mov si,_info1_msg	; mode number
	call puts
	mov ax,cx
	call wrnum

	mov bx,10		; (in decimal)
	mov si,_info2_msg	; X resolution
	call puts
	mov ax,[di + 18]
	call wrnum

	mov si,_info3_msg	; Y resolution
	call puts
	mov ax,[di + 20]
	mov [_ht],ax		; will clip against .BMP file height later
	call wrnum

	mov bx,16		; (in hex)
	mov si,_info4_msg	; LFB address
	call puts
	mov ax,[di + 40]
	mov dx,[di + 42]
	mov [_lfb_adr + 0],ax	; save LFB address
	mov [_lfb_adr + 2],dx
	call wrnum

	mov si,_crlf_msg
	call puts

	mov ax,[di + 16]	; bytes per row for screen is not...
	mov [_vbe_wd],ax	; ...necessarily (X resolution * depth)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Open 256-color .BMP file and display it
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	mov ah,3Dh		; open .BMP file
	mov al,0		; read-only
	mov dx,_bmp_file_name
	int 21h
	jnc open_ok
	mov si,_open_msg
	jmp mexit
open_ok:
	mov bx,ax		; save DOS file handle in BX

	mov ah,3Fh		; read 54-byte .BMP file header
	mov cx,54
	mov dx,_buf
	mov di,dx
	int 21h
	cmp byte [di + 0],'B'	; verify .BMP file magic
	jne bad_bmp
	cmp byte [di + 1],'M'
	jne bad_bmp
	cmp byte [di + 28],8	; verify 8 bits per pixel
	je bmp_ok
bad_bmp:
	mov si,_bad_bmp_msg
	jmp mexit
bmp_ok:
	mov ax,[di + 22]	; ht = min(bmp_ht, vbe_ht)
	cmp ax,[_ht]
	ja big_bmp
	mov [_ht],ax
big_bmp:
	mov ax,[di + 18]	; bytes per row for .BMP file
	mov [_bmp_wd],ax	; xxx - round up to a multiple of 4 bytes?

	mov si,_key_msg
	call puts
	mov ah,00h		; await key pressed
	int 16h

	mov ax,4F02h		; switch to graphics mode; enable LFB
	push bx
		mov bx,[_mode_num]
		or bx,4000h
		int 10h
	pop bx
	cmp ax,004Fh
	je mode_set_ok
	mov si,_mode_set_err_msg
	jmp mexit
mode_set_ok:
	mov ah,3Fh		; read 1024-byte palette
	mov cx,1024
	mov dx,_buf
	mov di,dx
	int 21h

	shr cx,1		; write 256 palette entries to VGA
	shr cx,1
	mov dx,3C8h
	xor al,al
	out dx,al
	mov dx,3C9h
	jmp short set_pal_2
set_pal_1:
	mov al,[di + 2]		; red
	shr al,1		; convert to 6-bit VGA palette entry
	shr al,1
	out dx,al

	mov al,[di + 1]		; green
	shr al,1
	shr al,1
	out dx,al

	mov al,[di + 0]		; blue
	shr al,1
	shr al,1
	out dx,al

	add di,byte 4		; skip unused 4th byte
set_pal_2:
	loop set_pal_1

	mov cx,[_ht]
	jmp short read_raster_2
read_raster_1:
	mov ah,3Fh		; read one scanline
	mov dx,_buf
	push cx
		mov cx,[_bmp_wd]
		int 21h
	pop cx
	jc read_raster_3

	call copy_row		; copy to LFB in extended memory

read_raster_2:
	loop read_raster_1
read_raster_3:
	mov ah,3Eh		; close .BMP file
	int 21h

	mov ah,00h		; await key pressed
	int 16h

	mov ax,0003h		; switch to text mode
	int 10h

	mov ax,4C00h		; exit to DOS with ERRORLEVEL=0
	int 21h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			copy_row
; action:		copies bytes from conventional memory to LFB
; in:			word [_bmp_wd] = bytes per row for .BMP file,
;			word [_vbe_wd] = bytes per row for LFB,
;			_buf = conventional memory buffer,
;			dword [_lfb_adr] = LFB address
; out:			(nothing)
; modifies:		[_lfb_adr] incremented
; minimum CPU:		'386 (top two bytes of each GDT entry != 0)
; notes:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

copy_row:
	push si
	push dx
	push cx
	push ax
		mov ax,ds		; set src adr in GDT (_buf)
		mov dx,16		; convert from near address...
		mul dx			; ...to linear
		add ax,_buf
		adc dx,byte 0		; SEG(_buf) * 16 + OFF(_buf)
		mov [_gdt_src + 2],ax
		mov [_gdt_src + 4],dl
		mov [_gdt_src + 7],dh

		mov ax,[_lfb_adr + 0]	; set dst adr in GDT (_lfb_adr)
		mov [_gdt_dst + 2],ax	; it's already a linear address,...
		mov ax,[_lfb_adr + 2]	; ...so just store it
		mov [_gdt_dst + 4],al
		mov [_gdt_dst + 7],ah

		mov si,_gdt
		mov cx,[_bmp_wd]	; xxx - min(_bmp_wd,_vbe_wd)
		shr cx,1		; WORD count; not bytes
		mov ah,87h
		int 15h

		mov ax,[_vbe_wd]	; increment [_lfb_adr]
		add [_lfb_adr + 0],ax
		mov ax,0		; use MOV to leave CY unchanged
		adc [_lfb_adr + 2],ax
	pop ax
	pop cx
	pop dx
	pop si
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			puts
; action:		displays text on stdout
; in:			0-terminated string at SI
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		8088
; notes:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

puts:
	push si
	push dx
	push ax
		cld
		mov ah,2
		jmp short puts_2
puts_1:
		mov dl,al
		int 21h
puts_2:
		;lodsb
		mov al,[si]
		inc si
		or al,al
		jne puts_1
	pop ax
	pop dx
	pop si
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			ltoa
; action:		converts 32-bit unsigned value to string
; in:			32-bit unsigned value in DX:AX, radix in BX,
;			SI -> buffer
; out:			(nothing)
; modifies:		SI
; minimum CPU:		8088
; notes:		SI must point to zero byte at END of buffer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ltoa:
	push dx
	push cx
	push ax

; extended precision division from section 9.3.5
; of Randall Hyde's "Art of Assembly"
; start: DX=dividend MSW, AX=dividend LSW, BX=divisor
ltoa_1:
		push ax
			mov ax,dx
			xor dx,dx

; before div: DX=0, AX=dividend MSW, BX=divisor
; after div:  AX=quotient MSW, DX=intermediate remainder
			div bx
			mov cx,ax
		pop ax

; before div: DX=intermediate remainder, AX=dividend LSW, BX=divisor
; after div:  AX=quotient LSW, DX=remainder
		div bx

; end: DX=quotient MSW, AX=quotient LSW, CX=remainder
		xchg dx,cx
		add cl,'0'
		cmp cl,'9'
		jbe ltoa_2
		add cl,('A'-('9'+1))
ltoa_2:
		dec si
		mov [si],cl

		mov cx,ax
		or cx,dx
		jne ltoa_1
	pop ax
	pop cx
	pop dx
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			wrnum
; action:		displays 32-bit value
; in:			32-bit unsigned value in DX:AX, radix in BX
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		8088
; notes:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

wrnum:
	push si
		mov si,_num_buf
		mov byte [si],0
		dec si
		call ltoa
		call puts
	pop si
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DATA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_mode_num:
	dw 0
_ht:
	dw 0
_bmp_wd:
	dw 0
_vbe_wd:
	dw 0
_lfb_adr:
	dd 0

; GDT for INT 15h AH=87h
_gdt:
	dd 0, 0			; NULL descriptor

	dd 0, 0			; descriptor used by BIOS

; source segment descriptor
_gdt_src:
	dw 0FFFFh		; segment limit 15:0
	dw 0			; segment base address 15:0; set in copy_row
	db 0			; segment base address 23:16; set in copy_row
	db 93h			; access byte: present, ring 0, writable data segment
	db 0CFh			; page-granular limit; 32-bit segment; limit 19:16
	db 0			; segment base address 31:24; set in copy_row

; destination segment descriptor
_gdt_dst:
	dw 0FFFFh		; segment limit 15:0
	dw 0			; segment base address 15:0; set in copy_row
	db 0			; segment base address 23:16; set in copy_row
	db 93h			; access byte: present, ring 0, writable data segment
	db 0CFh			; page-granular limit; 32-bit segment; limit 19:16
	db 0			; segment base address 31:24; set in copy_row

	dd 0, 0			; descriptor used by BIOS

	dd 0, 0			; descriptor used by BIOS
_gdt_end:

_no_vbe_msg:
	db "VBE 2.x video BIOS required", 13, 10, 0
_no_mode_msg:
	db "No 256-color video mode with linear framebuffer is available"
_crlf_msg:
	db 13, 10, 0
_info1_msg:
	db "Mode number=0x", 0
_info2_msg:
	db ", ", 0
_info3_msg:
	db "x", 0
_info4_msg:
	db "x256, linear framebuffer at 0x", 0
_open_msg:
	db "Can't open .BMP file", 13, 10, 0
_bad_bmp_msg:
	db "Not a 256-color .BMP file", 13, 10, 0
_key_msg:
	db "Press a key to continue", 13, 10, 0
_mode_set_err_msg:
	db "Error setting graphics mode", 13, 10, 0

_bmp_file_name:
	db "COW8.BMP", 0

_mode_buf:
	times 256 db 0
_num_buf:

_buf:
	db "VBE2"		; signature required to detect VBE2
	times 1024 db 0
