/*----------------------------------------------------------------------------
PnP Explorer

to do
- PnP: read tags for possible/allowed resource usage
- PnP: support the "dependent functions"
- PCI: move crufty, Borland-C-only asm to separate NASM file
	so this code works with 16-bit Watcom C again
- maybe allocate buf[] dynamically in pnp_read_res()
----------------------------------------------------------------------------*/
#include <stdio.h>
#if 0
/* C99 fixed-width types */
#include <stdint.h>
#else
typedef unsigned char	uint8_t;
typedef unsigned short	uint16_t;
typedef unsigned long	uint32_t;
#endif
/*----------------------------------------------------------------------------
HARDWARE RESOURCE MANAGER
----------------------------------------------------------------------------*/
#include <string.h>
#include <stdlib.h>

typedef struct
{
	char id[10];
	unsigned char _class, sub_class, api;
/* xxx - distinguish between multiple I/O ranges for a single configuration
    (e.g. 1F0h-1F7h and 3F6h for IDE hard drive)
and multiple I/O ranges for different configurations
    (e.g. 2F8h, 2E8h, 3F8h, 3E8h for COM ports)

I/O ranges */
	unsigned num_io;
	unsigned short *io_base;
	unsigned short *io_len;
/* memory ranges */
	unsigned num_mem;
	unsigned long *mem_base;
	unsigned long *mem_len;
/* IRQ mask
xxx - mask for multiple configs, else ordinal value
(right? only one IRQ line per device?) */
	uint16_t irq_mask;
/* DMA mask */
	uint16_t dma_mask;
} res_t;
/*****************************************************************************
these codes are used by both PnP and PCI
*****************************************************************************/
static void dump_class(unsigned _class, unsigned sub, unsigned api)
{
	static const char *class_name[] =
	{
		"reserved", "disk", "network controller", "display controller",
		"multimedia controller", "memory", "bridge", "comm device",
		"system device", "input device", "docking station", "CPU",
		"serial bus controller"
	};
/*	static const char *sub_name[13][] =	grrrrr */
	static const char *sub_name[13][8] =
	{
		{
			"reserved"
		}, {/* disks */
			"SCSI", "IDE", "floppy", "IPI", "RAID"
		}, {/* network controllers */
			"Ethernet", "Token Ring", "FDDI", "ATM"
		}, {/* display controllers */
			"VGA", "SuperVGA", "XGA"
		}, {/* multimedia controllers */
			"video", "audio"
		}, {/* memory */
			"RAM", "Flash"
		}, {/* bridge */
			"CPU", "ISA", "EISA", "MicroChannel",
			"PCI", "PCMCIA", "NuBus", "CardBus"
		}, {/* comms device */
			"PC serial port", "PC parallel port"
		}, {/* system device */
			"8259 PIC",
			"8327 DMAC",
			"8254 timer",
			"MC146818 RTC"
		}, {/* input device */
			"kbd controller", "digitizer/pen", "mouse"
		}, {/* docking station */
			"generic"
		}, {/* CPU */
			"386", "486", "Pentium", "Pentium Pro (P6)"
		}, {/* serial bus controller */
			"FireWire (IEEE 1394)", "ACCESS.bus", "SSA", "USB",
			"Fiber Channel", "SMBus"
		}
	};
/**/

	printf("class=%u", _class);
	if(_class < sizeof(class_name) / sizeof(class_name[0]))
	{
		printf(" (%s)", class_name[_class]);
		printf(", sub-class=%u", sub);
		if(sub < sizeof(sub_name) / sizeof(sub_name[0]) &&
			sub_name[_class][sub] != NULL)
				printf(" (%s)", sub_name[_class][sub]);
	}
	else
		printf(", sub-class=%u", sub);
	printf(", API flags=0x%02X\n", api);
}
/*****************************************************************************
*****************************************************************************/
static void dump_res(res_t *r)
{
	unsigned i, mask, comma;

	printf("%s: ", r->id);
	dump_class(r->_class, r->sub_class, r->api);
	for(i = 0; i < r->num_io; i++)
		printf("\tI/O=0x%03X-0x%03X\n", r->io_base[i],
			r->io_base[i] + r->io_len[i] - 1);
	for(i = 0; i < r->num_mem; i++)
		printf("\tmem=0x%08lX-0x%08lX\n", r->mem_base[i],
			r->mem_base[i] + r->mem_len[i] - 1);
	if(r->irq_mask)
	{
		printf("\tIRQ=");
		comma = 0;
		i = 15;
		for(mask = 0x8000; mask != 0; mask >>= 1)
		{
			if(mask & r->irq_mask)
			{
				if(comma)
					printf(", ");
				comma = 1;
				printf("%u", i);
			}
			i--;
		}
		putchar('\n');
	}
	if(r->dma_mask)
	{
		printf("\tDMA=");
		comma = 0;
		i = 7;
		for(mask = 0x80; mask != 0; mask >>= 1)
		{
			if(mask & r->dma_mask)
			{
				if(comma)
					printf(", ");
				comma = 1;
				printf("%u", i);
			}
			i--;
		}
		putchar('\n');
	}
}
/*****************************************************************************
*****************************************************************************/
static void destroy_res(res_t *r)
{
	if(r->io_base != NULL)
		free(r->io_base);
	if(r->io_len != NULL)
		free(r->io_len);
	if(r->mem_base != NULL)
		free(r->mem_base);
	if(r->mem_len != NULL)
		free(r->mem_len);
	memset(r, 0, sizeof(res_t));
}
/*****************************************************************************
*****************************************************************************/
static void add_io_to_res(res_t *r, unsigned base, unsigned len)
{
	unsigned short *new_io;

	new_io = (unsigned short *)realloc(r->io_base,
		(r->num_io + 1) * sizeof(unsigned short));
	if(new_io == NULL)
MEM:	{
printf("out of memory\n");
		return;
	}
	r->io_base = new_io;
	new_io = r->io_base + r->num_io;
	*new_io = base;

	new_io = (unsigned short *)realloc(r->io_len,
		(r->num_io + 1) * sizeof(unsigned short));
	if(new_io == NULL)
		goto MEM;
	r->io_len = new_io;
	new_io = r->io_len + r->num_io;
	*new_io = len;

	r->num_io++;
}
/*****************************************************************************
*****************************************************************************/
static void add_mem_to_res(res_t *r, unsigned long base, unsigned long len)
{
	unsigned long *new_mem;

	new_mem = (unsigned long *)realloc(r->mem_base,
		(r->num_mem + 1) * sizeof(unsigned long));
	if(new_mem == NULL)
MEM:	{
printf("out of memory\n");
		return;
	}
	r->mem_base = new_mem;
	new_mem = r->mem_base + r->num_mem;
	*new_mem = base;

	new_mem = (unsigned long *)realloc(r->mem_len,
		(r->num_mem + 1) * sizeof(unsigned long));
	if(new_mem == NULL)
		goto MEM;
	r->mem_len = new_mem;
	new_mem = r->mem_len + r->num_mem;
	*new_mem = len;

	r->num_mem++;
}
