/*****************************************************************************
to do:
- for current resource dump of DMAC and PIT, foo() overwrites
  res.indep_io with last of multiple values, so only one I/O
  range is displayed
- for current resource dump of system board, foo() overwrites
  res.indep_mem with last of multiple values, so only one memory
  range is displayed
- set mem_range_t's correctly

- rename functions foo() and bar()
- read and dump current resource usage as well as possible resource usage
- set current resource usage
- add command-line interface (SETPNP.C)
*****************************************************************************/


/*****************************************************************************
opens Craig Hart's PNPID.TXT file, searches it for the 5-character 'id',
prints the corresponding human-readable device name
*****************************************************************************/
#if 0

#define	MAX	128

static char *identify(char *id)
{
/* Turbo C++ 1.0 seems to "lose" anything declared 'static const'
	static const char *idfile_name = "pnpid.txt"; */
	static char *idfile_name = "pnpid.txt";
	static unsigned long file_len;
	static char init, entry[MAX];
	static FILE *idfile = NULL;
/**/
	long where, delta;
	int temp;

	if(!init)
	{
		init = 1;
		idfile = fopen(idfile_name, "r");
		if(idfile == NULL)
			printf("\t*** can't open PNP ID file '%s'\n",
				idfile_name);
		else
		{
			fseek(idfile, 0, SEEK_END);
			file_len = ftell(idfile);
		}
	}
	if(idfile == NULL)
		return NULL;
/* start in middle of file */
	where = delta = file_len >> 1;
	do
	{
/* binary-search up or down */
		delta >>= 1;
		fseek(idfile, where, SEEK_SET);
/* advance to newline */
		do temp = fgetc(idfile);
		while(temp != '\n');
/* read entry */
		fgets(entry, MAX, idfile);
/* compare IDs */
		temp = strncmp(entry, id, 7);
		if(temp > 0)
			where -= delta;
		else if(temp == 0)
		{
/* remove trailing newline */
			entry[strlen(entry) - 1] = '\0';
			return entry + 8;
		}
		else /*if(temp < 0)*/
			where += delta;
	} while(delta != 0);
	return NULL;
}
#endif
/*****************************************************************************
*****************************************************************************/
typedef struct
{
	uint8_t  flags; /* b0=10-bit I/O address */
	uint16_t lo, hi;
	uint8_t  incr, size;
} io_range_t;

typedef struct
{
	uint8_t  flags;
	uint32_t lo, hi;
	uint32_t incr;
	uint32_t size;
} mem_range_t;

typedef struct
{
/* possible resource assignments */
	io_range_t  indep_io,  dep_io;
	uint16_t    indep_irq, dep_irq;
	uint16_t    indep_dma, dep_dma;
	mem_range_t indep_mem, dep_mem;
/* current resource assignment,
used for iteration over possible resource assignments */
	unsigned      i_io,  d_io;
	unsigned      i_irq, d_irq;
	unsigned      i_dma, d_dma;
	unsigned long i_mem, d_mem;
} res_t;
/*****************************************************************************
Gulp! It works like this:

indep_io_loop()  calls indep_irq_loop()     calls indep_dma_loop() calls
indep_mem_loop() calls dep_io_loop()        calls dep_irq_loop()   calls
dep_dma_loop()   calls dep_mem_loop() which calls bar()

bar() displays one (out of possibly very many) possible
hardware resource configurations (IRQ, I/O, DMA, memory).

xxx - rename this function
*****************************************************************************/
static void bar(res_t *res)
{
	unsigned long lbase, lsize;
	unsigned base, size;

return;
/* independent I/O */
	size = res->indep_io.size;
	if(size)
	{
		base = res->i_io;
		printf("I/O=0x%3X-%3X, ", base, base + size - 1);
	}
/* dependent I/O */
	size = res->dep_io.size;
	if(size)
	{
		base = res->d_io;
		printf("I/O=0x%3X-%3X, ", base, base + size - 1);
	}
/* independent IRQ */
	if(res->indep_irq)
		printf("IRQ=%u, ", res->i_irq);
/* dependent IRQ */
	if(res->dep_irq)
		printf("IRQ=%u, ", res->d_irq);
/* independent DMA */
	if(res->indep_dma)
		printf("DMA=%u, ", res->i_dma);
/* dependent DMA */
	if(res->dep_dma)
		printf("DMA=%u, ", res->d_dma);
/* independent mem */
	lsize = res->indep_mem.size;
	if(lsize)
	{
		lbase = res->i_mem;
		printf("mem=0x%lX-%lX, ", lbase, lbase + lsize - 1);
	}
/* dependent mem */
	lsize = res->dep_mem.size;
	if(lsize)
	{
		lbase = res->d_mem;
		printf("mem=0x%lX-%lX, ", lbase, lbase + lsize - 1);
	}
	putchar('\n');
}
/*****************************************************************************
*****************************************************************************/
static void dep_mem_loop(res_t *res)
{
/* iterate over dependent memory ranges */
	if(res->dep_mem.size)
	{
		res->d_mem = res->dep_mem.lo;
		do
		{
			bar(res);
			res->d_mem += res->dep_mem.incr;
		} while(res->d_mem < res->dep_mem.hi);
	}
/* no dependent memory range */
	else
		bar(res);
}
/*****************************************************************************
*****************************************************************************/
static void dep_dma_loop(res_t *res)
{
	unsigned mask;

/* iterate over dependent DMAs */
	if(res->dep_dma)
	{
		res->d_dma = 7;
		for(mask = 0x0080; mask != 0; mask >>= 1)
		{
			if(mask & res->dep_dma)
				dep_mem_loop(res);
			res->d_dma--;
		}
	}
/* no dependent DMA */
	else
		dep_mem_loop(res);
}
/*****************************************************************************
*****************************************************************************/
static void dep_irq_loop(res_t *res)
{
	unsigned mask;

/* iterate over dependent IRQs */
	if(res->dep_irq)
	{
		res->d_irq = 15;
		for(mask = 0x8000; mask != 0; mask >>= 1)
		{
			if(mask & res->dep_irq)
				dep_dma_loop(res);
			res->d_irq--;
		}
	}
/* no dependent IRQ */
	else
		dep_dma_loop(res);
}
/*****************************************************************************
*****************************************************************************/
static void dep_io_loop(res_t *res)
{
/* iterate over dependent I/O ranges */
	if(res->dep_io.size)
	{
		res->d_io = res->dep_io.lo;
		do
		{
			dep_irq_loop(res);
			res->d_io += res->dep_io.incr;
		} while(res->d_io < res->dep_io.hi);
	}
/* no dependent I/O range */
	else
		dep_irq_loop(res);
}
/*****************************************************************************
*****************************************************************************/
static void indep_mem_loop(res_t *res)
{
/* iterate over independent memory ranges */
	if(res->indep_mem.size)
	{
		res->i_mem = res->indep_mem.lo;
		do
		{
			dep_io_loop(res);
			res->i_mem += res->indep_mem.incr;
		} while(res->i_mem < res->indep_mem.hi);
	}
/* no independent memory range */
	else
		dep_io_loop(res);
}
/*****************************************************************************
*****************************************************************************/
static void indep_dma_loop(res_t *res)
{
	unsigned mask;

/* iterate over independent DMAs */
	if(res->indep_dma)
	{
		res->i_dma = 7;
		for(mask = 0x0080; mask != 0; mask >>= 1)
		{
			if(mask & res->indep_dma)
				indep_mem_loop(res);
			res->i_dma--;
		}
	}
/* no independent DMA */
	else
		indep_mem_loop(res);
}
/*****************************************************************************
*****************************************************************************/
static void indep_irq_loop(res_t *res)
{
	unsigned mask;

/* iterate over independent IRQs */
	if(res->indep_irq)
	{
		res->i_irq = 15;
		for(mask = 0x8000; mask != 0; mask >>= 1)
		{
			if(mask & res->indep_irq)
				indep_dma_loop(res);
			res->i_irq--;
		}
	}
/* no independent IRQ */
	else
		indep_dma_loop(res);
}
/*****************************************************************************
*****************************************************************************/
static void indep_io_loop(res_t *res)
{
/* iterate over independent I/O ranges */
	if(res->indep_io.size)
	{
		res->i_io = res->indep_io.lo;
		do
		{
			indep_irq_loop(res);
			res->i_io += res->indep_io.incr;
		} while(res->i_io < res->indep_io.hi);
	}
/* no independent I/O range */
	else
		indep_irq_loop(res);
}
/*****************************************************************************
xxx - rename this function
*****************************************************************************/
static int foo(unsigned char *buf)
{
	unsigned i, j, rec_len, tag, tag_len, dep;
	res_t res;

	rec_len = *(uint16_t *)(buf + 0);
/* skip 12-byte header and tags describing current resource usage
xxx - get current resource usage */
#if 1
	for(i = 12; i < rec_len; i++)
	{
		if((buf[i] & 0xF8) == 0x78) /* END tag */
		{
			i = i + 1 + (buf[i] & 0x07); /* skip it */
			goto OK;
		}
	}
	printf("*** error finding device resources\n");
	return -1;
OK:
#else
	i = 12;
#endif
//dump(buf + i, rec_len - i);
	dep = 0;
	memset(&res, 0, sizeof(res));
/* process possible resource assignments */
	while(i < rec_len)
	{
/* large item (larger than 7 bytes) */
		if(buf[i] & 0x80)
		{
			tag = buf[i] & 0x7F;
			tag_len = *(uint16_t *)(buf + i + 1);
			i += 3;
/* 6: 32-bit memory range */
			if(tag == 6 && tag_len == 9)
			{
#if 1
				unsigned long lo, size;

				lo = *(uint32_t *)(buf + i + 1);
				size = *(uint32_t *)(buf + i + 5);
printf("mem=0x%lX-", lo);
printf("0x%lX\n", lo + size - 1);
				if(dep)
				{
					res.dep_mem.flags = buf[i + 0];
					res.dep_mem.lo = lo;
					res.dep_mem.hi = lo;
					res.dep_mem.incr = 0;
					res.dep_mem.size = size;
				}
				else
				{
					res.indep_mem.flags = buf[i + 0];
					res.indep_mem.lo = lo;
					res.indep_mem.hi = lo;
					res.indep_mem.incr = 0;
					res.indep_mem.size = size;
				}
#else
/* 1: 24-bit memory range */
				unsigned long lo, hi, incr, size;

dump(buf + i - 3, 9 + 3);
				lo = *(uint16_t *)(buf + i + 1) * 256L;
				hi = *(uint16_t *)(buf + i + 3) * 256L;
				j = *(uint16_t *)(buf + i + 5);
				incr = j ? j : 65536L;
				size = *(uint16_t *)(buf + i + 7) * 256L;
//if(buf[i + 0] & 0x01)
//	printf("10-bit ");
printf("mem=0x%lX-", lo);
printf("0x%lX, ", hi);
printf("align=%lu, ", incr);
printf("count=%lu\n", size);
				if(dep)
				{
					res.dep_mem.flags = buf[i + 0];
					res.dep_mem.lo = lo;
					res.dep_mem.hi = hi;
					res.dep_mem.incr = incr;
					res.dep_mem.size = size;
				}
				else
				{
					res.indep_mem.flags = buf[i + 0];
					res.indep_mem.lo = lo;
					res.indep_mem.hi = hi;
					res.indep_mem.incr = incr;
					res.indep_mem.size = size;
				}
#endif
			}
			else
			{
				printf("*** unrecognized large item %u "
					"(len=%u)\n", tag, tag_len);
				return -1;
			}
		}
/* small item */
		else
		{
			tag = (buf[i] >> 3) & 0x0F;
			tag_len = buf[i] & 0x07;
			i++;
/* 4: IRQ */
			if(tag == 4 && tag_len == 2)
			{
				j = *(uint16_t *)(buf + i);
printf("IRQ mask=0x%04X\n", j);
				if(dep)
					res.dep_irq = j;
				else
					res.indep_irq = j;
			}
/* 5: DMA */
			else if(tag == 5 && tag_len == 2)
			{
				j = *(uint16_t *)(buf + i);
printf("DMA mask=0x%04X\n", j);
				if(dep)
					res.dep_dma = j;
				else
					res.indep_dma = j;
			}
/* 6: begin dependent function */
			else if(tag == 6 && tag_len == 0)
			{
printf("begin dependent function\n");
				if(dep)
					indep_io_loop(&res);
				res.dep_irq = 0;
				res.dep_dma = 0;
				res.dep_io.size = 0;
				res.dep_mem.size = 0;
				dep = 1;
			}
/* 7: end depdendent function */
			else if(tag == 7 && tag_len == 0)
			{
printf("end dependent function\n");
				indep_io_loop(&res);
				dep = 0;
				memset(&res, 0, sizeof(res));
			}
/* 8: I/O range */
			else if(tag == 8 && tag_len == 7)
			{
				unsigned lo, hi, incr, size;

				lo = *(uint16_t *)(buf + i + 1);
				hi = *(uint16_t *)(buf + i + 3);
				incr = buf[i + 5];
				size = buf[i + 6];
if(buf[i + 0] & 0x01)
	printf("10-bit ");
printf("I/O=0x%03X-", lo);
printf("0x%03X, ", hi);
printf("align=%u, ", incr);
printf("count=%u\n", size);
				if(dep)
				{
					res.dep_io.flags = buf[i + 0];
					res.dep_io.lo = lo;
					res.dep_io.hi = hi;
					res.dep_io.incr = incr;
					res.dep_io.size = size;
				}
				else
				{
					res.indep_io.flags = buf[i + 0];
					res.indep_io.lo = lo;
					res.indep_io.hi = hi;
					res.indep_io.incr = incr;
					res.indep_io.size = size;
				}
			}
/* 15: end of resource list */
			else if(tag == 15)
			{
				if(!dep)
					indep_io_loop(&res);
				return 0;
			}
			else
			{
				printf("*** unrecognized small item %u "
					"(len=%u)\n", tag, tag_len);
				return -1;
			}
		}
		i += tag_len;
	}
	return 0;
}
