/*----------------------------------------------------------------------------
Interrupt demo code for 16-bit Watcom C
Chris Giese	<geezer@execpc.com>	http://my.execpc.com/~geezer
Release date: Feb 24, 2004
This code is public domain (no copyright).
You can do whatever you want with it.

language:	C
compiler:	Watcom C
CPU mode:	real mode (16-bit)
using DOS?	yes
----------------------------------------------------------------------------*/
#include <conio.h> /* cputs(), getch(), outp() */
#include <dos.h> /* MK_FP(), _dos_getvect(), _dos_setvect() */

#define	peekb(S,O)		*(unsigned char far *)MK_FP(S,O)
#define	pokeb(S,O,V)		*(unsigned char far *)MK_FP(S,O) = (V)
#define	TIMER_VECT		8
#define	SYSCALL_VECT		50
#define	SYS_CPUTS		0

/* macros and vector type for portability  */
#define	INTERRUPT		__interrupt
#define	HOOK(vec, num, fn)	(vec) = _dos_getvect(num); \
					_dos_setvect(num, (vector_t)(fn))
#define	UNHOOK(vec, num)	_dos_setvect(num, vec)

#ifdef __cplusplus
#error Ni!
typedef void INTERRUPT (*vector_t)(...);
#else
typedef void INTERRUPT (*vector_t)();
#endif
/*****************************************************************************
increment char in upper left corner of screen on every timer tick
*****************************************************************************/
static void INTERRUPT timer_int(void)
{
	pokeb(0xB800, 0, peekb(0xB800, 0) + 1);
	outp(0x20, 0x20);
}
/*****************************************************************************
Warning: 'gs' and 'fs' in INTPACKW are not valid unless
this code is compiled for '386 CPU or better (wcc -3 ...)
*****************************************************************************/
static void INTERRUPT syscall_int(struct INTPACKW regs)
{
	unsigned char syscall_num;

	syscall_num = regs.ax;
	syscall_num >>= 8;
	switch(syscall_num)
	{
		case SYS_CPUTS:
			cputs((char *)regs.si);
			break;
	}
}
/*****************************************************************************
*****************************************************************************/
int main(void)
{
	static const char *msg = "press a key to quit\n\r";
/**/
	vector_t old_timer_vector, old_syscall_vector;

/* save old vectors and install new handlers */
	HOOK(old_timer_vector, TIMER_VECT, timer_int);
	HOOK(old_syscall_vector, SYSCALL_VECT, syscall_int);
/* make a system call */
	_asm mov ah,SYS_CPUTS
	_asm mov si,msg
	_asm int SYSCALL_VECT;
/* await key pressed */
	getch();
/* restore old vectors */
	UNHOOK(old_timer_vector, TIMER_VECT);
	UNHOOK(old_syscall_vector, SYSCALL_VECT);
	return 0;
}
