/*****************************************************************************
interrupt handler demo

CPU mode:	real mode (16-bit)
using DOS?	yes
language:	Turbo C/C++

Note: use of 'interrupt' keyword may cause TLINK error
	"Cannot generate COM file : segment-relocatable items present"
*****************************************************************************/
#include <conio.h> /* getch(), cputs() */
#include <dos.h> /* peekb(), pokeb(), outportb(), getvect(), setvect() */

#define	TIMER_VECT	8
#define	SYSCALL_VECT	50
#define	SYS_CPUTS	0

/* vector type and macros for portability  */

#ifdef __cplusplus
typedef void interrupt (*vector_t)(...);
#else
typedef void interrupt (*vector_t)();
#endif

#define	INTERRUPT			interrupt

#define	SAVE_VECTOR(vec, num)		vec = getvect(num)
#define	INSTALL_HANDLER(vec, num, fn)	setvect(num, (vector_t)fn)
#define	RESTORE_VECTOR(vec, num)	setvect(num, vec)
/*****************************************************************************
increment char in upper left corner of screen on every timer tick
*****************************************************************************/
static void INTERRUPT timer_int(void)
{
	pokeb(0xB800, 0, peekb(0xB800, 0) + 1);
	outportb(0x20, 0x20);
}
/*****************************************************************************
*****************************************************************************/
#pragma argsused
static void INTERRUPT syscall_int(int junk, int di, int si, int ds,
		int es, int dx, int cx, int bx, int ax)
{
	unsigned char syscall_num;

	syscall_num = ax;
	syscall_num >>= 8;
	switch(syscall_num)
	{
		case SYS_CPUTS:
			cputs((char *)si);
			break;
	}
}
/*****************************************************************************
*****************************************************************************/
int main(void)
{
	static const char *msg = "press a key to quit\n\r";
/**/
	vector_t old_timer_vector, old_syscall_vector;

/* save old vectors */
	SAVE_VECTOR(old_timer_vector, TIMER_VECT);
	SAVE_VECTOR(old_syscall_vector, SYSCALL_VECT);
/* install new handlers */
	INSTALL_HANDLER(old_timer_vector, TIMER_VECT, timer_int);
	INSTALL_HANDLER(old_syscall_vector, SYSCALL_VECT, syscall_int);
/* make a system call */
	_AH = SYS_CPUTS;
	_SI = (unsigned)msg;
	asm int SYSCALL_VECT;
/* await key pressed */
	getch();
/* restore old vectors */
	RESTORE_VECTOR(old_timer_vector, TIMER_VECT);
	RESTORE_VECTOR(old_syscall_vector, SYSCALL_VECT);
	return 0;
}
