#include <stdio.h>

/* #include <stdint.h> */
typedef unsigned short uint16_t;

typedef struct
{
	uint16_t magic;
	uint16_t bils;	/* bytes in last sector */
	uint16_t sects;	/* file size, in 512-byte sectors */
	uint16_t num_relocs;
	uint16_t hdr_size;
	uint16_t min_heap;
	uint16_t max_heap;
	uint16_t init_ss;
	uint16_t init_sp;
	uint16_t checksum;
	uint16_t init_cs;
	uint16_t init_ip;
	uint16_t reloc_off;
	uint16_t overlay;
	uint16_t one;
} exe_file_t;

int g_bss, g_data = 42;
/*****************************************************************************
*****************************************************************************/
int main(int arg_c, char *arg_v[])
{
	unsigned long hsize, asize, cdsize, bsize, temp;
	exe_file_t file;
	FILE *in;

	if(arg_c != 2)
	{
		printf("Dumps headers of .EXE file\n");
		return 1;
	}
	in = fopen(arg_v[1], "rb");
	if(in == NULL)
	{
		printf("Can't open input file '%s'\n", arg_v[1]);
		return 1;
	}
	fread(&file, 1, sizeof(file), in);
	fseek(in, 0, SEEK_END);
	asize = ftell(in);
	fclose(in);
	if(file.magic != 0x5A4D)
	{
		printf("Not an .EXE file (bad magic numbers)\n");
		return 1;
	}
	hsize = file.sects;
	if(file.bils != 0)
		hsize--;
	hsize = 512 * hsize + file.bils;
	printf("File size: from headers=%lu, actual=%lu\n",
		hsize, asize);

	printf("Offset %5u (%5Xh): %u relocation(s)\n",
		file.reloc_off, file.reloc_off, file.num_relocs);

	temp = file.hdr_size * 16uL;
	cdsize = hsize - temp;
	printf("Offset %5lu (%5lXh): %lu bytes code + data\n",
		temp, temp, cdsize);

	temp = file.hdr_size * 16uL + file.init_cs * 16uL + file.init_ip;
	printf("Offset %5lu (%5lXh): entry point (initial CS:IP)\n",
		temp, temp);

	bsize = file.min_heap * 16uL;
	printf("Offset %5lu (%5lXh): %lu bytes BSS/heap/stack\n",
		hsize, hsize, bsize);

	temp = file.hdr_size * 16uL + file.init_ss * 16uL + file.init_sp;
	printf("Offset %5lu (%5lXh): bottom of stack "
		"(highest adr; initial SS:SP)\n", temp, temp);

	if(bsize == 0 && hsize != asize)
		printf("This file probably contains debug info\n");
	printf("\n");

//	printf("max_heap=%u\n", file.max_heap);
//	printf("checksum=%u\n", file.checksum);
//	printf("overlay=%u\n", file.overlay);
//	printf("one=%u\n", file.one);
	return 0;
}
