#include <stdio.h>
#include <dos.h>

#define	TIMEOUT	100000L
/*****************************************************************************
*****************************************************************************/
static int write_fdc(char *cmd, unsigned count)
{
	unsigned long timeout0, timeout;
	unsigned char i;

	timeout0 = TIMEOUT;
	for(timeout = timeout0; timeout != 0; timeout--)
	{
/* b7=data reg ready for I/O to/from CPU
b6=1 to FDC-to-CPU, =0 for CPU-to-FDC */
		i = inportb(0x3F4);
		if((i & 0xC0) == 0x80)
			break;
	}
	if(timeout == 0)
	{
printf("write_fdc: timeout! (status=0x%02X)\n", i);
		return -1;
	}
printf("write_fdc: waited %lu clocks\n", timeout0 - timeout);
	for(; count != 0; count--)
	{
		outportb(0x3F5, *cmd);
		cmd++;
	}
	return 0;
}
/*****************************************************************************
*****************************************************************************/
static int read_fdc(char *result, unsigned count)
{
	unsigned long timeout0, timeout;
	unsigned char i;

	timeout0 = TIMEOUT;
	for(timeout = timeout0; timeout != 0; timeout--)
	{
/* b7=data reg ready for I/O to/from CPU
b6=1 to FDC-to-CPU, =0 for CPU-to-FDC */
		i = inportb(0x3F4);
		if((i & 0xC0) == 0xC0)
			break;
	}
	if(timeout == 0)
	{
printf("read_fdc: timeout! (status=0x%02X)\n", i);
		return -1;
	}
printf("read_fdc: waited %lu clocks\n", timeout0 - timeout);
	for(; count != 0; count--)
	{
		*result = inportb(0x3F5);
		result++;
	}
	return 0;
}
/*****************************************************************************
*****************************************************************************/
static int wait_for_interrupt(void)
{
	unsigned long timeout0, timeout;
	unsigned char i;

	timeout0 = 1000000L;
	for(timeout = timeout0; timeout != 0; timeout--)
	{
		i = peekb(0x40, 0x3E);
		if(i & 0x80)
			break;
		(void)inportb(0x80);
	}
	if(timeout == 0)
	{
printf("wait_for_interrupt: timeout! (status=0x%02X)\n", i);
		return -1;
	}
printf("wait_for_interrupt: waited %lu clocks for interrupt\n", timeout0 - timeout);
	pokeb(0x40, 0x3E, i & ~0x80);
	return 0;
}
/*****************************************************************************
*****************************************************************************/
static int recalibrate(void)
{
	char result[2];

/* recalibrate */
	if(write_fdc("\x07\x00", 2))
		return -1;
	if(wait_for_interrupt())
		return -1;
/* sense interrupt */
	if(write_fdc("\x08", 1))
		return -1;
// xxx - must I wait here for an interrupt?
	if(read_fdc(result, sizeof(result)))
		return -1;
	if((result[0] & 0xC0) != 0 ||	/* success? */
		result[1] != 0)		/* now on track #0? */
			return -1;
	return 0;
}
/*****************************************************************************
*****************************************************************************/
int main(void)
{
	unsigned seek, read;
	char buf[9];

/* b0-b1=0: select floppy drive A:
b2=1: release FDC from reset
b3=1: enable DMA and I/O (?)
b4=1, b7-b5=0: turn on motor for floppy drive A: */
	outportb(0x3F2, 0x1C);
/* set data rate to 500000 bits/second */
	outportb(0x3F7, 0);
	(void)recalibrate();
	delay(500);
	for(seek = 3; seek != 0; seek--)
	{
		for(read = 3; read != 0; read--)
		{
// xxx - init DMAC
/* issue read command
b6=1 for MFM mode
b5=1 to skip address mark of deleted data */
			buf[0] = 0x62;
/* b0-b1=0 to select drive A:, b2=0 to select head 0 */
			buf[1] = 0;
/* CHS */
			buf[2] = buf[3] = buf[4] = 0;
/* bytes/sector */
			buf[5] = 512;
/* last sector in track */
			buf[6] = 18;
/* gap3 length */
			buf[7] = 0;//xxx?
/* data length (?) */
			buf[8] = 0;
			if(write_fdc(buf, 9))
				goto ERR;
			if(wait_for_interrupt())
				goto ERR;
/* read status and check */
			if(read_fdc(buf, 7))
				goto ERR;
			if((buf[0] & 0xC0) == 0)
				goto OK;
		}
		(void)recalibrate();
	}
ERR:
printf("error\n");
	return 0;
OK:
printf("success\n");
	return 0;
}
