# defines
# MAKEDEP	=watcom.mak
#TCDIR	=c:\t
#LIBDIR	=$(TCDIR)\lib
#INCDIR	=$(TCDIR)\include
#TCC	=tcc -v  -mt  -w  -O2 -d -Z -1 -vi -Iinc -I$(INCDIR)
#NASM	=nasm -f obj -dTINY=1
#EXELINK	=tlink /v /x /c /3
#EXELINK	=tlink /x /c /3
#COMLINK	=tlink /t /x /c /3
#BING	=startup.o lib.o bing.o			browse.o \
#	diskio.o mounts.o vfs.o ext2.o fat.o	conio.o \
#	elf.o coff.o pe.o exe.o
# *wcc hello.c -bt=dos

# targets
all: bing.exe
#bing.com

clean:
	deltree /y *.o *.exe *.com

# I don't know if Watcom MAKE supports implicit rules...?
# dependencies

# explicit rules
lib.o: lib.asm
  *nasm -f obj -o lib.o lib.asm

mounts.o: mounts.c defs.h inc/dirent.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=mounts.o mounts.c

diskio.o: diskio.c defs.h inc/dirent.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=diskio.o diskio.c

vfs.o: vfs.c
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=vfs.o vfs.c

browse.o: browse.c
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=browse.o browse.c

conio.o: conio.c
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=conio.o conio.c

ext2.o: ext2.c
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=ext2.o ext2.c

fat.o: fat.c
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=fat.o fat.c

bing.o: bing.c execfile.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=bing.o bing.c

elf.o: elf.c execfile.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=elf.o elf.c

pe.o: pe.c execfile.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=pe.o pe.c

exe.o: exe.c execfile.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=exe.o exe.c

coff.o: coff.c execfile.h
  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=coff.o coff.c

#load.o: load.c execfile.h
#  *wcc -0 -s -d2 -hc -i. -iinc -iC:\WATCOM\h -ox -of+ -w=9 -zc -fo=load.o load.c

bing.com: mounts.o diskio.o vfs.o browse.o conio.o ext2.o fat.o bing.o elf.o pe.o exe.o coff.o
  *wlink SYS dos com N bing.com OP nod F lib.o F mounts.o F diskio.o F vfs.o F browse.o F conio.o F ext2.o F fat.o F bing.o F elf.o F pe.o F exe.o F coff.o LIBF mylib.lib
#load.o

bing.exe: mounts.o diskio.o vfs.o browse.o conio.o ext2.o fat.o bing.o elf.o pe.o exe.o coff.o
  *wlink SYS dos N bing.exe D A OP nod F lib.o F mounts.o F diskio.o F vfs.o F browse.o F conio.o F ext2.o F fat.o F bing.o F elf.o F pe.o F exe.o F coff.o LIBF mylib.lib
#load.o
#  LIBF C:\WATCOM\LIB286\DOS\CLIBS.LIB
