; NASM startup code gotchas:
; - load ES before using REP STOSB to zero the BSS (duh)
; - load DS with DGROUP for SMALL model
; - do not put _TEXT in DGROUP for SMALL model
; - do not declare anything "static const" in your C code
; - put "resb 100h" before "..start" for TINY model, like the NASM FAQ says
; - for both .COM and .EXE, DS and ES point to the PSP on entry
; - ALL NASM files in the project must contain identical
;   GROUP and SEGMENT definitions

; IMPORTS
; from LIB.ASM
EXTERN _asm_init
EXTERN _asm_exit
EXTERN __dos

; from C code
EXTERN _main



SEGMENT _TEXT PUBLIC CLASS=CODE

%ifdef TINY
	resb 100h
%endif

GLOBAL __code
__code:

SEGMENT _DATA PUBLIC CLASS=DATA
GLOBAL __data
__data:

SEGMENT _BSS PUBLIC CLASS=BSS
GLOBAL __bss
__bss:

SEGMENT _BSSEND PUBLIC CLASS=BSSEND ALIGN=16
GLOBAL __end
__end:

%ifdef TINY
GROUP DGROUP _TEXT _DATA _BSS _BSSEND

%else
GROUP DGROUP _DATA _BSS _BSSEND
%endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SEGMENT _TEXT

; NASM syntax to specify entry point
..start:

; load segment registers and set stack
%ifdef TINY
	mov dx,cs
%else
	mov dx,DGROUP
%endif
	mov ds,dx	; leave ES:0 -> PSP
	mov ss,dx
	mov sp,stack

; zero the BSS. Save ES so we can test for DOS later
; by checking for a PSP at address [ES:0]
	mov ax,es
	xchg dx,ax
	mov es,ax
	xor ax,ax
	mov di,__bss
	mov cx,__end
	sub cx,di
	rep stosb
	mov es,dx

; extra startup and other asm code needed for bootloader
	call _asm_init

; call C code
	call _main
exit:
	xor ax,ax
	call _asm_exit
	or al,[__dos]
	jne dos_exit
	int 19h		; re-start the boot process
dos_exit:
	mov ax,4C01h
	int 21h		; exit to DOS with errorlevel 1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			wrstr
; action:		writes ASCIZ string to text screen
; in:			0-terminated string at DS:SI
; out:			(nothing)
; modifies:		(nothing)
; minimum CPU:		8088
; notes:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

wrstr:
	push ax
	push bx
	push si
		mov ah,0Eh	; INT 10h: teletype output
		xor bx,bx	; video page 0
		jmp wrstr2
wrstr1:
		int 10h
wrstr2:
		lodsb
		or al,al
		jne wrstr1
	pop si
	pop bx
	pop ax
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; name:			__REALCVT
; action:		traps attempts to use printf() with floating point
; in:			(nothing)
; out:			DOES NOT RETURN
; modifies:		AX
; minimum CPU:		8088
; notes:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

GLOBAL __REALCVT
__REALCVT:
	push ds
		mov si,cs
		mov ds,si
		mov si,fp_msg
		call wrstr
	pop ds
	jmp exit

fp_msg:
	db "printf() not linked with floating point support, aborting..."
	db 13, 10, 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SEGMENT _BSS

; my filesystem code uses a lot of stack (4K is too small!)
	times 4096 dw 0
stack:

