/*============================================================================
PE.C - PMODE (32-BIT) Win32 PE KERNELS

EXPORTS:
int check_pe_header(exec_t *exec, unsigned handle,
		unsigned long rdsk_offset, unsigned long image_base);
============================================================================*/
#include <string.h> /* memcmp() */
#include <stdio.h> /* SEEK_... */
#include <errno.h>
#include <io.h> /* read(), lseek() */
#include "execfile.h"
#include "defs.h"

/* IMPORTS
from COFF.C */
int check_coff_header(exec_t *exec, unsigned handle,
		unsigned long rdsk_offset, unsigned long image_base);
/*****************************************************************************
*****************************************************************************/
int check_pe_header(exec_t *exec, unsigned handle,
		unsigned long rdsk_offset, unsigned long image_base)
{
	static const char *format_name = "Win32 PE";
/**/
	unsigned long new_exe_offset, img_base;
	char buf[64];
	int err;

/* seek to start of kernel within RDSK file */
	lseek(handle, rdsk_offset, SEEK_SET);
/* read 64-byte old executable (DOS .EXE) header */
	if(read(handle, buf, 64) != 64)
/* short file is not PE */
		return -ERR_FILE_FORMAT;
	if(memcmp(buf, "MZ", 2) != 0)
		return -ERR_FILE_FORMAT;
	new_exe_offset = read_le32(buf + 60);
	if(new_exe_offset == 0)
		return -ERR_FILE_FORMAT;
/* lseek to and read first 64 bytes of new executable (PE) header */
	lseek(handle, rdsk_offset + new_exe_offset, SEEK_SET);
	if(read(handle, buf, 64) != 64)
		return -ERR_FILE_FORMAT;
	if(memcmp(buf, "PE", 2) != 0)
		return -ERR_FILE_FORMAT;
/* read image base */
	img_base = read_le32(buf + 52);
/* the rest of the file is COFF format */
	err = check_coff_header(exec, handle,
		rdsk_offset + new_exe_offset + 4, img_base);
	exec->format_name = format_name;
	return err;
}
