/*****************************************************************************
MOUNTS

EXPORTS:
int mount(drv_t *drv, const char *mount_pt);
int get_mount(const char **path_p, mount_t **mount_p);
*****************************************************************************/
#include <string.h> /* NULL, strncpy(), strlen() */
#include <errno.h>
#include "defs.h"

/* IMPORTS
from FAT.C */
int fat_mount(mount_t *mount, drv_t *drv);

/* from EXT2.C */
int ext2_mount(mount_t *mount, drv_t *drv);

/* from CONIO.C */
int printf(const char *fmt, ...);

#define	MAX_MOUNT	4

/*static*/ mount_t _mounts[MAX_MOUNT];
/*****************************************************************************
mounts device drv->dev_num partition drv->part_num
on subdirectory mount_pt
*****************************************************************************/
int mount(drv_t *drv, const char *mount_pt)
{
	mount_t *mount;
	unsigned i;

/* find a free mount_t */
	for(i = 0; i < MAX_MOUNT; i++)
	{
		mount = _mounts + i;
		if(mount->drv == NULL)
			break;
	}
	if(i >= MAX_MOUNT)
	{
		printf("mount table full\n");
		return -1;
	}
	mount->drv = drv;
	strncpy(mount->mount_pt, mount_pt, MAX_NAME_LEN);
	if(fat_mount(mount, drv) != 0)
	if(ext2_mount(mount, drv) != 0)
	{
		printf("mount of drive 0x%02X", drv->dev_num);
		if(drv->part_num >= 0)
			printf(" partition %u", drv->part_num);
		printf(" failed (unknown filesystem)\n");
		mount->drv = NULL;
		return -1;
	}
	return 0;
}
/*****************************************************************************
compares beginning of path_p to mount points,
strips the mount point from path_p and sets mount_p
*****************************************************************************/
int get_mount(const char **path_p, mount_t **mount_p)
{
	const char *path;
	mount_t *mount;
	int i, len = 0;

	path = (*path_p);
/* xxx - mounts must be sorted in decreasing order of strlen(mount->mount_pt)
	for(i = 0; i < MAX_MOUNT; i++) */
	for(i = MAX_MOUNT - 1; i >= 0; i--)
	{
		mount = _mounts + i;
		if(mount->drv == NULL)
			continue;
		len = strlen(mount->mount_pt);
		if(!strncmp(path, mount->mount_pt, len))
			break;
	}
	if(i >= MAX_MOUNT)
	{
		printf("get_mount failed\n");
		return -1;
	}
	if(path[0] == '/' && len == 1)
		path++;
	else
		path += len + 1; /* +1 to eat trailling slash */
	(*path_p) = path;
	(*mount_p) = mount;
	return 0;
}

