#ifndef	__MY_DIRENT_H
#define	__MY_DIRENT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "defs.h" /* MAX_NAME_LEN, file_t */

struct dirent
{
	char d_name[MAX_NAME_LEN];
};

typedef struct
{
	file_t *file;
	struct dirent ent;
} DIR;

DIR * opendir(char *path);
struct dirent *readdir(DIR *dir);
int closedir(DIR *dir);
void rewinddir(DIR *dir);

#ifdef __cplusplus
}
#endif

#endif
