#ifndef	__MY_EXECFILE_H
#define	__MY_EXECFILE_H

#ifdef __cplusplus
extern "C" {
#endif

#define	HUGE			far

/* these assume sizeof(short)==2 and sizeof(long)==4
and little-endian CPU like x86 */
#define	read_le16(X)		*(unsigned short *)(X)
#define	read_le32(X)		*(unsigned long *)(X)

typedef long	off_t;

#define	MAX_SECT	4

typedef struct
{
	unsigned load : 1;		/* section flags: load from disk? */
	unsigned zero : 1;		/* BSS? */
	unsigned read : 1;		/* readable? */
	unsigned write : 1;		/* writable? */
	unsigned exec : 1;		/* executable? */
	unsigned long off, size, adr;	/* file offset, size, virtual adr */
	char name[12];			/* section name (e.g. ".bss") */
} sect_t;

typedef struct
{
	unsigned long entry_pt;		/* initial EIP or CS:IP */
	unsigned short num_sections;	/* sections (.text, .data, .bss) */
	sect_t section[MAX_SECT];
	const char *format_name;	/* name of file format */
	unsigned pmode : 1;		/* 32-bit kernel? */
	unsigned rdsk : 1;		/* RDSK file? */
} exec_t;

#ifdef __cplusplus
}
#endif

#endif
