/*============================================================================
EXE.C - REAL MODE (16-BIT) DOS .EXE KERNELS

EXPORTS:
int check_exe_header(exec_t *exec, unsigned handle,
		unsigned long rdsk_offset, unsigned long image_base);
============================================================================*/
#include <string.h> /* memcmp() */
#include <stdio.h> /* SEEK_nnn */
#include <errno.h>
#include <io.h> /* read(), lseek() */
#include "execfile.h"
#include "defs.h"
/*****************************************************************************
*****************************************************************************/
int check_exe_header(exec_t *exec, unsigned handle,
		unsigned long rdsk_offset, unsigned long image_base)
{
	static const char *format_name = "DOS .EXE";
/**/
	unsigned long new_exe_offset;
	char buf[64];

/* seek to start of kernel within RDSK file */
	lseek(handle, rdsk_offset, SEEK_SET);
/* read 64-byte old executable (DOS .EXE) header */
	if(read(handle, buf, 64) != 64)
/* short file is not EXE */
		return -ERR_FILE_FORMAT;
	if(memcmp(buf, "MZ", 2) != 0)
		return -ERR_FILE_FORMAT;
/* if header is 64 bytes or more, check for New Executable */
	if(read_le16(buf + 24) >= 64)
	{
		new_exe_offset = read_le32(buf + 60);
		if(new_exe_offset != 0)
			return -ERR_FILE_FORMAT;
	}
/* xxx - finish */

	exec->num_sections = 0;
	exec->format_name = format_name;
	exec->pmode = 0;

/*	return -1; */
	return 0;
}
