#ifndef	__MY_DEFS_H
#define	__MY_DEFS_H

#ifdef __cplusplus
extern "C" {
#endif

#if 1
#define	DEBUG(X)	X
#else
#define	DEBUG(X)	/* nothing */
#endif

/* these assume sizeof(short)==2 and sizeof(long)==4
and little-endian CPU like x86 */
#define	read_le16(X)	*(unsigned short *)(X)
#define	read_le32(X)	*(unsigned long *)(X)
#define	write_le16(X,V)	*(unsigned short *)(X) = (V)
#define	write_le32(X,V)	*(unsigned long *)(X) = (V)

#define	MAX_NAME_LEN	256

/* additional error numbers
For Turbo C, _sys_nerr is defined in ERRNO.H */
#if defined(__TURBOC__)

#define	ENOIMP		-(_sys_nerr + 1)
#define	ERR_FILE_FORMAT	-(_sys_nerr + 2)
#define	ERR_FILE_SYSTEM	-(_sys_nerr + 3)
#define	ERR_FILE_NAME	-(_sys_nerr + 4)

#elif defined(__WATCOMC__)

#define	ENOIMP		-50
#define	ERR_FILE_FORMAT	-51
#define	ERR_FILE_SYSTEM	-52
#define	ERR_FILE_NAME	-53
#endif

/* access to BIOS interrupts from C */
#if defined(__TURBOC__)

#define	R_AX	r_ax
#define	R_BX	r_bx
#define	R_CX	r_cx
#define	R_DX	r_dx
#define	R_SI	r_si

#define	R_BP	r_bp
#define	R_ES	r_es
#define	R_DS	r_ds
#define	R_FLAGS	r_flags

typedef struct REGPACK regs_t;

#elif defined(__WATCOMC__)

#define	R_AX	w.ax
#define	R_BX	w.bx
#define	R_CX	w.cx
#define	R_DX	w.dx
#define	R_SI	w.si

#define	R_BP	w.bp
#define	R_ES	w.es
#define	R_DS	w.ds
#define	R_FLAGS	w.flags

typedef union REGPACK regs_t;

#endif

/* screen layout */
#define	WIDTH		80
/*#define	HEIGHT		25

#define	TOP_LEFT_X	0
#define	TOP_LEFT_Y	0 */

#define	BANNER_HT	4

/*#define	LISTBOX_X	0*/

#define	LISTBOX_Y	BANNER_HT
#define	LISTBOX_HT	16
#define	LISTBOX_COLS	3
#define	LISTBOX_COLWD	13
/*#define	LISTBOX_WD	(LISTBOX_COLS * LISTBOX_COLWD) */
/* this must be even */
#define	LISTBOX_FILES	(LISTBOX_HT * LISTBOX_COLS)

#define	INFO_X		(WIDTH / 2)
#define	INFO_Y		(LISTBOX_Y + 1)
/*#define	INFO_WD		(WIDTH / 2 - 1)
#define	INFO_HT		(HEIGHT - INFO_Y) */

#define	MSG_X		0
#define	MSG_Y		(LISTBOX_Y + LISTBOX_HT + 2)
/*#define	MSG_WD		(WIDTH - MSG_X)
#define	MSG_HT		(HEIGHT - MSG_Y) */



















#if defined(__TURBOC__)
#if __TURBOC__<0x0300

/* TC 2.0 preprocessor is fubar, I guess...chokes on DEBUG(X) macro
in get_hard_disk_geometry() in file DISKIO.C */
#undef DEBUG(X)
#define	DEBUG(X)

/* grrrr... */
#ifndef NULL
#define NULL	0
#endif

#endif
#endif

/* huge pointers are buggy for Turbo C 3.0,
OK for Turbo C 2.0 and Borland C 3.1 */
#define	HUGE		far

/* 20 bytes for FAT, 16 bytes for ext2. When calculating these values,
keep in mind that some compilers pack structs, others don't */
#define	MOUNT_INFO_SIZE	20
/* 2 bytes for FAT, 60 bytes for ext2 */
#define	FILE_INFO_SIZE	64

typedef long	off_t;

typedef struct
{
	unsigned char dev_num;		/* INT 13h drv num */
	unsigned char heads, sectors;	/* floppy and CHS HD only */
	unsigned short bps;		/* bytes per sector, usu. 512 */
	signed char part_num;		/* HD only, 0-3 or -1 for entire disk */
	unsigned char part_type;	/* read from MBR or 0 for unknown */
	unsigned long part_start;	/* LBA of first sector of partition */
	unsigned long part_size;	/* or disk size */
	unsigned use_lba : 1;
} drv_t;

typedef struct
{
	drv_t *drv;
	const struct _fs_info *fs_info;
	char mount_pt[MAX_NAME_LEN];
	unsigned char fs_mount_info[MOUNT_INFO_SIZE];
} mount_t;

typedef struct
{
	off_t pos;
	mount_t *mount;
	char is_open;
/* the rest is the same as dirent_t */
	unsigned char fs_file_info[FILE_INFO_SIZE];
	char name[MAX_NAME_LEN];
	unsigned short mode;
	off_t size;
} file_t;

typedef struct
{
	unsigned char fs_file_info[FILE_INFO_SIZE];
	char name[MAX_NAME_LEN];
	unsigned short mode;
	off_t size;
} dirent_t;

#include "dirent.h" /* struct dirent */

typedef struct _fs_info
{
	const char *name;
	off_t (*read)(file_t *file, unsigned char HUGE *buf, off_t count);
	int (*readdir)(file_t *file, struct dirent *ent);
	int (*find)(file_t *file, const char *name, const unsigned name_len);
} fs_info_t;

#ifdef __cplusplus
}
#endif

#endif
