# only GNU MAKE needs .SUFFIXES:
# .SUFFIXES: .asm

# defines
MAKEDEP	=comfile.mak
TCDIR	=c:\tc
LIBDIR	=$(TCDIR)\lib
INCDIR	=$(TCDIR)\include
TCC	=tcc -mt  -w  -O2 -d -Z -1 -vi -Iinc -I$(INCDIR)
NASM	=nasm -f obj -dTINY=1
TLINK	=tlink /t /x /c /3
BING	=startup.o lib.o bing.o			browse.o \
	diskio.o mounts.o vfs.o ext2.o fat.o	conio.o \
	elf.o coff.o pe.o exe.o


# targets
all: bing.com

clean:
	deltree /y *.o *.exe *.com

# implicit rules
.c.o:
# old Turbo MAKE doesn't understand $@
#	$(TCC) -c -o$@ $<
	$(TCC) -c -o$*.o $<

.asm.o:
#	$(NASM) -o$@ $<
	$(NASM) -o$*.o $<

# dependencies
startup.o:	startup.asm	$(MAKEDEP)

lib.o:		lib.asm		$(MAKEDEP)

bing.o:		bing.c		$(MAKEDEP)	defs.h \
	inc/io.h	execfile.h

browse.o:	browse.c	$(MAKEDEP)	defs.h \
	inc/dirent.h	inc/sys/stat.h

diskio.o:	diskio.c	$(MAKEDEP)	defs.h

mounts.o:	mounts.c	$(MAKEDEP)	defs.h

vfs.o:		vfs.c		$(MAKEDEP)	defs.h \
	inc/dirent.h	inc/sys/stat.h		inc/io.h

ext2.o:		ext2.c		$(MAKEDEP)	defs.h \
	inc/dirent.h	inc/sys/stat.h

fat.o:		fat.c		$(MAKEDEP)	defs.h \
	inc/dirent.h	inc/sys/stat.h

conio.o:	conio.c		$(MAKEDEP)

elf.o:		elf.c		$(MAKEDEP)	defs.h \
	inc/io.h	execfile.h

coff.o:		coff.c		$(MAKEDEP)	defs.h \
	inc/io.h	execfile.h

pe.o:		pe.c		$(MAKEDEP)	defs.h \
	inc/io.h	execfile.h

exe.o:		exe.c		$(MAKEDEP)	defs.h \
	inc/io.h	execfile.h

# explicit rules
# Turbo MAKE 2.0 doesn't support this syntax
bing.com: $(BING) $(MAKEDEP)
	$(TLINK) @&&!
$(BING)
bing.com
# no .MAP file
$(LIBDIR)\cs.lib
!
