/*****************************************************************************
FILE BROWSER

EXPORTS
int browse_files(char *cwd_path, char *selection_path);
*****************************************************************************/
#include <sys/stat.h> /* S_IFDIR, struct stat, stat() */
/* NULL, strlen(), strncat(), strstr(), strncmp(), memmove() */
#include <string.h> /* strchr(), strncmp(), strcpy() */
/* DIR, struct dirent, opendir(), rewinddir(), readdir(), closedir() */
#include <dirent.h>
#include "defs.h" /* for screen layout values */

/* IMPORTS
from CONIO.C */
int getch(void);
int printf(const char *fmt, ...);
/*****************************************************************************
*****************************************************************************/
static void strmaxcat(char *dst, char *src)
{
	strncat(dst, src, MAX_NAME_LEN - (strlen(dst) + 1));
}
/*****************************************************************************
xxx - normalize_path() should prepend path to current dir if path is relative
xxx - normalize_path() doesn't work for "." directories
*****************************************************************************/
static void normalize_path(char *path)
{
	char *p, *q, *prev_dir;

/* strip . directories from path */
	while((p = strstr(path, "/./")) != NULL)
		memmove(p, p + 2, strlen(p + 2) + 1);
/* strip .. directories from path */
	prev_dir = NULL;
	for(q = path; (p = strchr(q, '/')) != NULL; q = p + 1)
	{
		if((strncmp(p, "/../", 3) == 0) && (prev_dir != NULL))
			memmove(prev_dir, p + 3, strlen(p + 3) + 1);
		prev_dir = p;
	}
	if(path[0] == '\0')
		strcpy(path, "/");
}
/*****************************************************************************
*****************************************************************************/
int browse_files(char *cwd_path, char *selection_path)
{
	char curr_path[MAX_NAME_LEN], selected_item_is_dir = 0;
	int selection, skip, num_files;
	struct dirent *entry;
	struct stat statbuf;
	unsigned pos, key;
	DIR *curr_dir;

	while(1)
	{
		skip = selection = 0;
		num_files = 0;
/* open directory */
		curr_dir = opendir(cwd_path);
		if(curr_dir == NULL)
		{
			printf("can't open dir '%s'\n", cwd_path);
			return -1;
		}
		while(1)
		{
/* seek to beginning of dir */
			rewinddir(curr_dir);
/* maybe skip some files */
			for(num_files = 0; num_files < skip; num_files++)
			{
				entry = readdir(curr_dir);
				if(entry == NULL)
				{
					printf("error from readdir() while "
						"skipping files\n");
					return -1;
				}
			}
/* display some files */
			printf("\x1B[%u;0H", LISTBOX_Y);
			pos = 0;
			for(; num_files < skip + LISTBOX_FILES; num_files++)
			{
/* read one dir entry */
				entry = readdir(curr_dir);
				if(entry == NULL)
					break;
/* form full path to item */
				strcpy(curr_path, cwd_path);
				if(curr_path[strlen(curr_path) - 1] != '/')
					strmaxcat(curr_path, "/");
				strmaxcat(curr_path, entry->d_name);
				normalize_path(curr_path);
/* stat it (to see if item is a directory) */
				stat(curr_path, &statbuf);
/* if this is the selected item, remember entry name */
				if(num_files == selection)
				{
					strcpy(selection_path, curr_path);
/* ...and remember if it's a dir */
					if(statbuf.st_mode & S_IFDIR)
						selected_item_is_dir = 1;
					else
						selected_item_is_dir = 0;
/* ...and set bright white on blue text */
					printf("\x1B[37;44;1m");
				}
/* set bright blue on black text for non-selected directories */
				else if(statbuf.st_mode & S_IFDIR)
					printf("\x1B[1;34;40m");
/* set white on black text for non-selected files */
				else
					printf("\x1B[37;40;0m");
/* move cursor */
				if(pos % LISTBOX_COLS == 0)
					printf("\n");
				pos++;
/* display entry name */
				if(statbuf.st_mode & S_IFDIR)
					printf("/%-*.*s ", LISTBOX_COLWD - 2,
						LISTBOX_COLWD - 2,
						entry->d_name);
				else
					printf("%-*.*s ", LISTBOX_COLWD - 1,
						LISTBOX_COLWD - 1,
						entry->d_name);
			}
/* finish counting files */
			while(readdir(curr_dir) != NULL)
				num_files++;
/* display blanks to fill in listbox */
			printf("\x1B[37;40;0m"); /* white on black */
			for(; pos < LISTBOX_FILES; pos++)
			{
				if(pos % LISTBOX_COLS == 0)
					printf("\n");
				printf("%-*.*s", LISTBOX_COLWD,
					LISTBOX_COLWD, "");
			}
/* get key */
			key = getch();
			if(key == 0)
				key = 0x100 | getch();
/* handle Enter */
			if(key == 13)
			{
				if(selected_item_is_dir)
				{
					closedir(curr_dir);
					strcpy(cwd_path, selection_path);
					break;
				}
/* return 0 for success */
				else
				{
					closedir(curr_dir);
					return 0;
				}
			}
/* arrow keys=move cursor */
			else if(key == 0x14D)
				selection++;
			else if(key == 0x14B)
				selection--;
			else if(key == 0x148)
				selection -= LISTBOX_COLS;
			else if(key == 0x150)
				selection += LISTBOX_COLS;
			else if(key == 0x151)
				selection += LISTBOX_FILES / 2;
			else if(key == 0x149)
				selection -= LISTBOX_FILES / 2;
/* if Esc, quit */
			else if(key == 27)
			{
				closedir(curr_dir);
				return -1;
			}
			if(selection < 0)
				selection = 0;
			if(selection < skip)
			{
				do skip -= LISTBOX_COLS;
				while(selection < skip);
			}
			if(selection >= num_files)
				selection = num_files - 1;
			if(selection >= skip + LISTBOX_FILES)
			{
				do skip += LISTBOX_COLS;
				while(selection >= skip + LISTBOX_FILES);
			}
		}
	}
}
