/*****************************************************************************
explode RDSK-format RAM disk into individual files
*****************************************************************************/
/* NULL, memicmp(), memcpy(), memset(), strlen(), strcpy(), strncpy() */
#include <string.h>
/* FILE, SEEK_nnn, printf(), remove(), fopen(), fwrite(), fread(),
fgets(), fseek(), ftell(), fclose() */
#include <stdio.h>

#define min(a,b)    (((a) < (b)) ? (a) : (b))
#define	read_le16(X)	(*(unsigned short *)(X))
#define	read_le32(X)	(*(unsigned long *)(X))

#define	BUF_LEN	512
/*****************************************************************************
*****************************************************************************/
int main(int arg_c, char *arg_v[])
{
	char *outfile_name, *infile_name, buf[BUF_LEN];
	unsigned long num_objs, i, temp, size;
	FILE *infile, *outfile;

	if(arg_c < 2)
	{
		printf("Explodes Mbius initial RAM disk image into "
			"separate files\n");
		return 1;
	}
	infile_name = arg_v[1];
	infile = fopen(infile_name, "rb");
	if(infile == NULL)
	{
		printf("Can't open input file '%s'\n", infile_name);
		return 2;
	}
	if(fread(buf, 1, 8, infile) != 8)
	{
NOT:		printf("File '%s' is not a Mbius initial RAM disk "
			"image\n", infile_name);
		fclose(infile);
		return 3;
	}
/* Tarnation! Tim changed the magic value! */
//	if(memcmp(buf, "KSDR", 4) != 0)
	if(memcmp(buf, "RDSK", 4) != 0)
		goto NOT;
	num_objs = read_le32(buf + 4);
	for(i = 0; i < num_objs; i++)
	{
		fseek(infile, 8 + 24 * i, SEEK_SET);
		if(fread(buf, 1, 24, infile) != 24)
		{
			printf("Error reading file '%s'\n", infile_name);
			fclose(infile);
			return 4;
		}
		fseek(infile, read_le32(buf + 0), SEEK_SET);
		size = read_le32(buf + 4);
		outfile_name = buf + 8;
		outfile = fopen(outfile_name, "wb");
		if(outfile == NULL)
		{
			printf("Can't open output file '%s'\n",
				outfile_name);
			fclose(infile);
			return 5;
		}
		do
		{
			temp = fread(buf, 1, min(BUF_LEN, size), infile);
			fwrite(buf, 1, temp, outfile);
			size -= temp;
		} while(size != 0);
		fclose(outfile);
//		printf("%lu, %lu, '%s'\n", read_le32(buf + 0),
//			read_le32(buf + 4), buf + 8);
	}
	fclose(infile);
	return 0;
}
