/*****************************************************************************
creates Mbius RAM disk image from files
Chris Giese <geezer@execpc.com>, http://www.execpc.com/~geezer

Tim Robinson's Mbius OS: http://www.gaat.freeserve.co.uk/
*****************************************************************************/
/* NULL, memicmp(), memcpy(), memset(), strlen(), strcpy(), strncpy() */
#include <string.h>
/* FILE, SEEK_nnn, printf(), remove(), fopen(), fwrite(), fread(),
fgets(), fseek(), ftell(), fclose() */
#include <stdio.h>

#define	BUF_LEN	512
/*****************************************************************************
*****************************************************************************/
int main(int arg_c, char *arg_v[])
{
	char *oname, iname[BUF_LEN], buf[BUF_LEN];
	char *temp1, *temp2, using_response_file = 0;
	FILE *resp, *in, *out;
	int i, j, k, num_files;

/* */
	if(arg_c < 3)
	{
USAGE:		printf("Creates Mbius intial RAM disk from files\n"
			"Usage: rdsk -o outfile ifile1 ifile2 ... ifileN\n"
			"       rdsk -ooutfile @listfile\n");
		return 1;
	}
/* get output file name */
	if(memicmp("-o", arg_v[1], 2))
		goto USAGE;
	if(arg_v[1][2] != '\0')
	{
		oname = arg_v[1] + 2;	/* rdsk -ooutfile ... */
		i = 2;
	}
	else
	{
		if(arg_c < 4)
			goto USAGE;
		oname = arg_v[2] + 0;	/* rdsk -o outfile ... */
		i = 3;
	}
/* open outfile (overwrite if it already exists) */
	out = fopen(oname, "wb");
	if(out == NULL)
	{
		printf("Can't open output file '%s'\n", oname);
		return 2;
	}
/* using a response file to get around DOS command-line length limits? */
	if(arg_v[i][0] == '@')
	{
		using_response_file = 1;
		resp = fopen(arg_v[i] + 1, "r");
		if(resp == NULL)
		{
			printf("Can't open response file '%s'\n",
				arg_v[i] + 1);
			return 2;
		}
		num_files = 0;
		while(fgets(iname, BUF_LEN, resp) != NULL)
		{
/* xxx - skip blank lines, maybe allow comments... */
			num_files++;
		}
/* leave resp open, but go back to start of file */
		fseek(resp, 0, SEEK_SET);
	}
	else
	{
		using_response_file = 0;
		num_files = arg_c - i;
	}
/* write signature and number of files to output */
	printf("Creating Mbius initial RAM disk '%s' from %u object(s):\n",
		oname, num_files);
	memcpy(buf + 0, "RDSK", 4);
	*(unsigned long *)(buf + 4) = num_files;
	fwrite(buf, 1, 8, out);
/* write a dummy directory, to extend the output file */
	memset(buf, 0, 24);
	for(j = 0; j < (num_files + 1); j++)/* xxx */
//	for(j = 0; j < num_files; j++)/* xxx */
		fwrite(buf, 1, 24, out);
/* for each input object */
	for(j = 0; j < num_files; j++)
	{
		unsigned long len, pos;

/* get input file name */
		if(using_response_file)
		{
			fgets(iname, BUF_LEN, resp);
/* gets() removes the newline, fgets() doesn't...sigh */
			if(iname[strlen(iname) - 1] == '\n')
				iname[strlen(iname) - 1] = '\0';
		}
		else
		{
			strncpy(iname, arg_v[i], BUF_LEN - 1);
			i++;
		}
/* open it */
		in = fopen(iname, "rb");
		if(in == NULL)
		{
			printf("\nCan't open input file '%s'\n", iname);
			if(using_response_file)
				fclose(resp);
			fclose(out);
/* delete output file */
			remove(oname);
			return 2;
		}
		printf("'%s'\t", iname);
/* get length of input file */
		fseek(in, 0, SEEK_END);
		len = ftell(in);
		fseek(in, 0, SEEK_SET);
/* get current output file pos (i.e. current len of output file) */
		pos = ftell(out);
/* seek to directory in output file; write object offset, len, and name */
		fseek(out, 8 + 24 * j, SEEK_SET);
		*(unsigned long *)(buf + 0) = pos;
		*(unsigned long *)(buf + 4) = len;
		memset(buf + 8, 0, 16);
/* trim path components from object name */
		temp1 = iname;
		do
		{
			temp2 = strchr(temp1, '\\');
			if(temp2 == NULL)
				temp2 = strchr(temp1, '/');
			if(temp2 != NULL)
				temp1 = temp2 + 1;
		} while(temp2 != NULL);
		strncpy(buf + 8, temp1, 15);

		fwrite(buf, 1, 24, out);
/* seek to end of output file; write input object */
		fseek(out, 0, SEEK_END);
		do
		{
			k = fread(buf, 1, BUF_LEN, in);
			fwrite(buf, 1, k, out);
		} while(k == BUF_LEN);
/* close input object */
		fclose(in);
	}
/* I guess it worked... */
	fclose(out);
	printf("\nSuccess!\n");
	return 0;
}
