#include <_size_t.h>
/*****************************************************************************
*****************************************************************************/
void *memmove(void *dst_ptr, const void *src_ptr, size_t count) /* string.h */
{
	void *ret_val = dst_ptr;
	const char *src = (const char *)src_ptr;
	char *dst = (char *)dst_ptr;

	if(dst_ptr < src_ptr)	/* copy up */
	{
		for(; count != 0; count--)
			*dst++ = *src++;
	}
	else			/* copy down */
	{
		dst += (count - 1);
		src += (count - 1);
		for(; count != 0; count--)
			*dst-- = *src--;
	}
	return ret_val;
}
