#include <stdlib.h> /* malloc(), free() */
#include <string.h> /* memcpy() */
#include <_malloc.h>
/*****************************************************************************
*****************************************************************************/
void *realloc(void *blk, size_t size)
{
	malloc_t *t_blk;
	void *new_blk;

/* this is easy */
	if(blk == NULL)
		return malloc(size);
/* so is this */
	if(size == 0)
	{
		free(blk);
		return NULL;
	}
/* point to data in old block */
	blk = (char *)blk - sizeof(malloc_t);
	t_blk = (malloc_t *)blk;
/* xxx - is this needed? won't free() do this for us?
should we make the other test, like free() does? */
	if(t_blk->magic != MALLOC_MAGIC)
	{
/*		printf("*** warning: krealloc() called with bad pointer %p "
			"(bad magic value) ***\n", blk); */
		return blk; /* xxx- NULL */
	}
/* alloc new block (larger or smaller) */
	new_blk = malloc(size);
	if(new_blk == NULL)
		return NULL;
/* copy data */
	memcpy(new_blk, blk, t_blk->size);
/* release old block */
	free(blk);
/* return new block */
	return new_blk;
}
