#include <_malloc.h>

void *sbrk(int incr);

malloc_t *_heap_bot, *_heap_top;
/*****************************************************************************
*****************************************************************************/
void *malloc(size_t size)
{
	size_t total_size;
	malloc_t *blk;

/* this is easy */
	if(size == 0)
		return NULL;
	total_size = size + sizeof(malloc_t);
/* heap doesn't exist yet */
	if(_heap_bot == NULL)
	{
/* expand data segment with sbrk() */
		blk = sbrk(total_size);
		if((int)blk == -1)
			return NULL;
		_heap_bot = _heap_top = blk;
/* if sbrk() gave us more memory than we wanted,
split off the excess to form an unused block
xxx - punt
		blk->size = (size_t)sbrk(0) - (size_t)blk; */
		blk->size = size;

		blk->next = NULL;
		blk->magic = MALLOC_MAGIC;
		blk->used = 1;
		return (char *)blk + sizeof(malloc_t);
	}
/* search heap for free block (FIRST FIT) */
	for(blk = _heap_bot; blk != NULL; blk = blk->next)
	{
/* xxx - size == blk->size would be a perfect fit; should I allow it? */
		if(!blk->used && total_size <= blk->size)
			break;
	}
/* found one */
	if(blk != NULL)
	{
		malloc_t *new_blk;

		new_blk = (malloc_t *)((char *)blk + total_size);
/* point to new empty block and downsize it */
		new_blk->used = 0;
		new_blk->size = blk->size - total_size;
		new_blk->next = blk->next;
		new_blk->magic = MALLOC_MAGIC;
/* set _heap_top if necessary */
		if(new_blk->next == NULL)
			_heap_top = new_blk;
/* point to new used block and set it */
		blk->used = 1;
		blk->size = size;
		blk->next = new_blk;
		blk->magic = MALLOC_MAGIC;
		return (char *)blk + sizeof(malloc_t);
	}
/* enlarge heap */
	blk = sbrk(total_size);
	if((int)blk == -1)
		return NULL;
	blk->used = 1;
	blk->size = size;
	blk->next = NULL;
	blk->magic = MALLOC_MAGIC;
/* this block is the new end-of-heap */
	_heap_top->next = blk;
	_heap_top = blk;
	return (char *)blk + sizeof(malloc_t);
}
