#include <_malloc.h>
/*****************************************************************************
*****************************************************************************/
void free(void *blk)
{
	malloc_t *t_blk;

/* get the actual address of the block */
	blk = (char *)blk - sizeof(malloc_t);
	t_blk = (malloc_t *)blk;
	if(t_blk->magic != MALLOC_MAGIC)
	{
/*		printf("*** warning: kfree() called with bad pointer %p "
			"(bad magic value) ***\n", blk); */
		return;
	}
/* find it */
	for(t_blk = _heap_bot; t_blk != NULL; t_blk = t_blk->next)
	{
		if(t_blk == blk)
			break;
	}
/* not found? bad pointer or no heap or something else? */
	if(t_blk == NULL)
	{
/*		printf("*** warning: kfree() called with bad pointer %p "
			"(pointer not found) ***\n", blk); */
		return;
	}
/* free the block */
	t_blk->used = 0;
/* coalesce adjacent kfree blocks
Hard to spell, hard to do */
	for(t_blk = _heap_bot; t_blk != NULL; t_blk = t_blk->next)
	{
		while(!t_blk->used && (t_blk->next != NULL) &&
			!t_blk->next->used)
		{
/* resize this block */
			t_blk->size += sizeof(malloc_t) + t_blk->next->size;
/* merge with next block */
			t_blk->next = t_blk->next->next;
		}
	}
}
