#include <setjmp.h> /* jmp_buf */
/*****************************************************************************
*****************************************************************************/
__inline__ void longjmp(jmp_buf buf, int ret_val)
{
	unsigned *esp2;

/* make sure return value is not 0 */
	if(ret_val == 0)
		ret_val++;
/* store it in buf->eax */
	buf->eax = ret_val;
/* get ESP for new stack */
	esp2 = (unsigned *)buf->esp2;
/* push return EIP on new stack */
	esp2--;
	*esp2 = buf->eip;
/* update stored ESP */
	buf->esp2 = (unsigned)esp2;
/* make buf the stack */
	__asm__ __volatile__("movl %0,%%esp\n"
/* pop GP registers */
		"popa\n"
/* pop ESP for new stack */
		"pop %%esp\n"
/* return */
		"ret\n"
		:
		: "m"(buf));
}
