#ifndef __TL_STDLIB_H
#define	__TL_STDLIB_H

#ifdef __cplusplus
extern "C" {
#endif

#include <_size_t.h>
#include <_null.h>

#define	max(X,Y)	((X)>(Y) ? (X) : (Y))
#define	min(X,Y)	((X)>(Y) ? (Y) : (X))
#define	abs(X)		((X)< 0  ? (-(X)) : (X))

void srand(unsigned new_seed);
unsigned rand(void);

void *malloc(size_t size);
void free(void *blk);
void *realloc(void *blk, size_t size);
void *calloc(size_t count, size_t size);

#ifdef __cplusplus
}
#endif

#endif

