#ifndef __TL_STDIO_H
#define	__TL_STDIO_H

#ifdef __cplusplus
extern "C"
{
#endif /* #ifdef __cplusplus */

#include <stdarg.h> /* va_list */
#include <_null.h>

#define	_IONBF	0	/* unbuffered stream */
#define _IOFBF  1	/* fully buffered stream */
#define _IOLBF  2	/* line and fully buffered stream */

#define	stdin	(_std_streams + 0)
#define	stdout	(_std_streams + 1)
//#define	stderr	(_std_streams + 2)

#define	EOF	(-1)

/* size of default stdio.h buffers */
#define BUFSIZ	53

#define	putchar(char)	fputc(char, stdout)

typedef struct
{
	char *buf_base, *buf_ptr;
	unsigned long size, room, flags;
	int handle;
} FILE;

extern FILE _std_streams[];

int fflush(FILE *stream);
int fputc(int c, FILE *stream);
int fputs(const char *str, FILE *stream);
int printf(const char *fmt, ...);
void setbuf(FILE *stream, char *buffer);
int sprintf(char *buffer, const char *fmt, ...);
int vprintf(const char *fmt, va_list args);
int vsprintf(char *buffer, const char *fmt, va_list args);

#ifdef __cplusplus
}
#endif /* #ifdef __cplusplus */

#endif /* #ifndef __TL_STDIO_H */
