#ifndef _TL_X86_H
#define	_TL_X86_H

#ifdef __cplusplus
extern "C"
{
#endif /* def __cplusplus */

#include <_size_t.h>

#define	outport(P,V)	outportw(P,V)
#define	inport(P)	inportw(P)

/* these first three aren't x86-specific. I may move them elsewhere */
unsigned disable(void);
void crite(unsigned flags);
void enable(void);

void fmemsetw(unsigned short sel, unsigned long off, unsigned short val,
	size_t count);

unsigned char inportb(unsigned short port);
void outportb(unsigned short port, unsigned char val);

unsigned char peekb(unsigned short sel, unsigned long off);
void pokeb(unsigned short sel, unsigned long off, unsigned char val);

void pokew(unsigned short sel, unsigned long off, unsigned short val);

unsigned long peekl(unsigned short sel, unsigned long off);
void pokel(unsigned short sel, unsigned long off, unsigned long val);

#ifdef __cplusplus
}
#endif /* def __cplusplus */

#endif /* ifndef _TL_X86_H */
